/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.admin;

import com.google.common.collect.ImmutableMultimap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUtils {
    private static final Logger log = LoggerFactory.getLogger(TaskUtils.class);

    private TaskUtils() {
    }

    public static int parseShardParam(ImmutableMultimap<String, String> params) throws Exception {
        int shard;
        if (!params.containsKey((Object)"shardId")) {
            log.warn("No shard specified for blacklisting");
            throw new Exception("No shard id provided");
        }
        String shardValue = params.get((Object)"shardId").asList().stream().findFirst().orElse(null);
        if (null == shardValue) {
            log.warn("No shard value specified for shardId during blacklisting");
            throw new Exception("Null shard id provided");
        }
        try {
            shard = Integer.parseInt(shardValue);
        }
        catch (NumberFormatException e) {
            log.error("Invalid shard id provided", (Throwable)e);
            throw new Exception("Invalid shard id provided: " + shardValue);
        }
        return shard;
    }
}

