/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.hibernate.AbstractDAO;
import io.dropwizard.hibernate.HibernateBundle;
import io.dropwizard.hibernate.SessionFactoryFactory;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.sharding.admin.BlacklistShardTask;
import io.dropwizard.sharding.admin.UnblacklistShardTask;
import io.dropwizard.sharding.caching.LookupCache;
import io.dropwizard.sharding.caching.RelationalCache;
import io.dropwizard.sharding.config.ShardedHibernateFactory;
import io.dropwizard.sharding.dao.CacheableLookupDao;
import io.dropwizard.sharding.dao.CacheableRelationalDao;
import io.dropwizard.sharding.dao.LookupDao;
import io.dropwizard.sharding.dao.RelationalDao;
import io.dropwizard.sharding.dao.WrapperDao;
import io.dropwizard.sharding.sharding.BucketIdExtractor;
import io.dropwizard.sharding.sharding.InMemoryLocalShardBlacklistingStore;
import io.dropwizard.sharding.sharding.ShardBlacklistingStore;
import io.dropwizard.sharding.sharding.ShardManager;
import io.dropwizard.sharding.sharding.impl.ConsistentHashBucketIdExtractor;
import io.dropwizard.sharding.utils.ShardCalculator;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import org.hibernate.SessionFactory;
import org.reflections.Reflections;

public abstract class DBShardingBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final String DEFAULT_NAMESPACE = "default";
    private static final String SHARD_ENV = "db.shards";
    private static final String DEFAULT_SHARDS = "2";
    private List<HibernateBundle<T>> shardBundles = Lists.newArrayList();
    private List<SessionFactory> sessionFactories;
    private ShardManager shardManager;
    private String dbNamespace;

    public DBShardingBundle(String dbNamespace, Class<?> entity, Class<?> ... entities) {
        this.dbNamespace = dbNamespace;
        ImmutableList inEntities = ImmutableList.builder().add(entity).add((Object[])entities).build();
        this.init(inEntities);
    }

    public DBShardingBundle(String dbNamespace, List<String> classPathPrefixList) {
        this.dbNamespace = dbNamespace;
        Set entities = new Reflections(new Object[]{classPathPrefixList}).getTypesAnnotatedWith(Entity.class);
        Preconditions.checkArgument((!entities.isEmpty() ? 1 : 0) != 0, (Object)String.format("No entity class found at %s", String.join((CharSequence)",", classPathPrefixList)));
        ImmutableList inEntities = ImmutableList.builder().addAll((Iterable)entities).build();
        this.init(inEntities);
    }

    public DBShardingBundle(Class<?> entity, Class<?> ... entities) {
        this(DEFAULT_NAMESPACE, entity, entities);
    }

    public DBShardingBundle(String ... classPathPrefixes) {
        this(DEFAULT_NAMESPACE, Arrays.asList(classPathPrefixes));
    }

    private void init(ImmutableList<Class<?>> inEntities) {
        String numShardsEnv = System.getProperty(String.join((CharSequence)".", this.dbNamespace, DEFAULT_NAMESPACE), System.getProperty(SHARD_ENV, DEFAULT_SHARDS));
        int numShards = Integer.parseInt(numShardsEnv);
        this.shardManager = new ShardManager(numShards, this.getBlacklistingStore());
        int i = 0;
        while (i < numShards) {
            final int finalI = i++;
            this.shardBundles.add(new HibernateBundle<T>(inEntities, new SessionFactoryFactory()){

                protected String name() {
                    return String.format("connectionpool-%s-%d", DBShardingBundle.this.dbNamespace, finalI);
                }

                public PooledDataSourceFactory getDataSourceFactory(T t) {
                    return (PooledDataSourceFactory)DBShardingBundle.this.getConfig(t).getShards().get(finalI);
                }
            });
        }
    }

    public void run(T configuration, Environment environment) {
        this.sessionFactories = this.shardBundles.stream().map(HibernateBundle::getSessionFactory).collect(Collectors.toList());
        environment.admin().addTask((Task)new BlacklistShardTask(this.shardManager));
        environment.admin().addTask((Task)new UnblacklistShardTask(this.shardManager));
    }

    public void initialize(Bootstrap<?> bootstrap) {
        this.shardBundles.forEach(hibernateBundle -> bootstrap.addBundle((ConfiguredBundle)hibernateBundle));
    }

    @VisibleForTesting
    public void runBundles(T configuration, Environment environment) {
        this.shardBundles.forEach(hibernateBundle -> {
            try {
                hibernateBundle.run(configuration, environment);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @VisibleForTesting
    public void initBundles(Bootstrap bootstrap) {
        this.shardBundles.forEach(hibernameBundle -> this.initialize(bootstrap));
    }

    public ShardBlacklistingStore getBlacklistingStore() {
        return new InMemoryLocalShardBlacklistingStore();
    }

    protected abstract ShardedHibernateFactory getConfig(T var1);

    public static <EntityType, T extends Configuration> LookupDao<EntityType> createParentObjectDao(DBShardingBundle<T> bundle, Class<EntityType> clazz) {
        return new LookupDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, new ConsistentHashBucketIdExtractor()));
    }

    public static <EntityType, T extends Configuration> CacheableLookupDao<EntityType> createParentObjectDao(DBShardingBundle<T> bundle, Class<EntityType> clazz, LookupCache<EntityType> cacheManager) {
        return new CacheableLookupDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, new ConsistentHashBucketIdExtractor()), cacheManager);
    }

    public static <EntityType, T extends Configuration> LookupDao<EntityType> createParentObjectDao(DBShardingBundle<T> bundle, Class<EntityType> clazz, BucketIdExtractor<String> bucketIdExtractor) {
        return new LookupDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, bucketIdExtractor));
    }

    public static <EntityType, T extends Configuration> CacheableLookupDao<EntityType> createParentObjectDao(DBShardingBundle<T> bundle, Class<EntityType> clazz, BucketIdExtractor<String> bucketIdExtractor, LookupCache<EntityType> cacheManager) {
        return new CacheableLookupDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, bucketIdExtractor), cacheManager);
    }

    public static <EntityType, T extends Configuration> RelationalDao<EntityType> createRelatedObjectDao(DBShardingBundle<T> bundle, Class<EntityType> clazz) {
        return new RelationalDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, new ConsistentHashBucketIdExtractor()));
    }

    public static <EntityType, T extends Configuration> CacheableRelationalDao<EntityType> createRelatedObjectDao(DBShardingBundle<T> bundle, Class<EntityType> clazz, RelationalCache<EntityType> cacheManager) {
        return new CacheableRelationalDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, new ConsistentHashBucketIdExtractor()), cacheManager);
    }

    public static <EntityType, T extends Configuration> RelationalDao<EntityType> createRelatedObjectDao(DBShardingBundle<T> bundle, Class<EntityType> clazz, BucketIdExtractor<String> bucketIdExtractor) {
        return new RelationalDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, bucketIdExtractor));
    }

    public static <EntityType, T extends Configuration> CacheableRelationalDao<EntityType> createRelatedObjectDao(DBShardingBundle<T> bundle, Class<EntityType> clazz, BucketIdExtractor<String> bucketIdExtractor, RelationalCache<EntityType> cacheManager) {
        return new CacheableRelationalDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, bucketIdExtractor), cacheManager);
    }

    public static <EntityType, DaoType extends AbstractDAO<EntityType>, T extends Configuration> WrapperDao<EntityType, DaoType> createWrapperDao(DBShardingBundle<T> bundle, Class<DaoType> daoTypeClass) {
        return new WrapperDao(bundle.sessionFactories, daoTypeClass, new ShardCalculator<String>(bundle.shardManager, new ConsistentHashBucketIdExtractor()));
    }

    public static <EntityType, DaoType extends AbstractDAO<EntityType>, T extends Configuration> WrapperDao<EntityType, DaoType> createWrapperDao(DBShardingBundle<T> bundle, Class<DaoType> daoTypeClass, BucketIdExtractor<String> bucketIdExtractor) {
        return new WrapperDao(bundle.sessionFactories, daoTypeClass, new ShardCalculator<String>(bundle.shardManager, bucketIdExtractor));
    }

    public static <EntityType, DaoType extends AbstractDAO<EntityType>, T extends Configuration> WrapperDao<EntityType, DaoType> createWrapperDao(DBShardingBundle<T> bundle, Class<DaoType> daoTypeClass, Class[] extraConstructorParamClasses, Class[] extraConstructorParamObjects) {
        return new WrapperDao(bundle.sessionFactories, daoTypeClass, extraConstructorParamClasses, extraConstructorParamObjects, new ShardCalculator<String>(bundle.shardManager, new ConsistentHashBucketIdExtractor()));
    }

    public List<SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public ShardManager getShardManager() {
        return this.shardManager;
    }

    public String getDbNamespace() {
        return this.dbNamespace;
    }
}

