/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.utils;

import io.dropwizard.sharding.sharding.BucketIdExtractor;
import io.dropwizard.sharding.sharding.ShardManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardCalculator<T> {
    private static final Logger log = LoggerFactory.getLogger(ShardCalculator.class);
    private final ShardManager shardManager;
    private final BucketIdExtractor<T> extractor;

    public ShardCalculator(ShardManager shardManager, BucketIdExtractor<T> extractor) {
        this.shardManager = shardManager;
        this.extractor = extractor;
    }

    public int shardId(T key) {
        int bucketId = this.extractor.bucketId(key);
        return this.shardManager.shardForBucket(bucketId);
    }

    public boolean isOnValidShard(T key) {
        int bucketId = this.extractor.bucketId(key);
        return this.shardManager.isMappedToValidShard(bucketId);
    }
}

