/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.dao;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.dropwizard.hibernate.AbstractDAO;
import io.dropwizard.sharding.dao.RelationalDao;
import io.dropwizard.sharding.sharding.BucketIdExtractor;
import io.dropwizard.sharding.sharding.LookupKey;
import io.dropwizard.sharding.sharding.ShardManager;
import io.dropwizard.sharding.utils.ShardCalculator;
import io.dropwizard.sharding.utils.TransactionHandler;
import io.dropwizard.sharding.utils.Transactions;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupDao<T> {
    private static final Logger log = LoggerFactory.getLogger(LookupDao.class);
    private List<LookupDaoPriv> daos;
    private final Class<T> entityClass;
    private final ShardManager shardManager;
    private final BucketIdExtractor<String> bucketIdExtractor;
    private final Field keyField;

    public LookupDao(List<SessionFactory> sessionFactories, Class<T> entityClass, ShardManager shardManager, BucketIdExtractor<String> bucketIdExtractor) {
        this.shardManager = shardManager;
        this.bucketIdExtractor = bucketIdExtractor;
        this.daos = sessionFactories.stream().map(x$0 -> new LookupDaoPriv((SessionFactory)x$0)).collect(Collectors.toList());
        this.entityClass = entityClass;
        Field[] fields = FieldUtils.getFieldsWithAnnotation(entityClass, LookupKey.class);
        Preconditions.checkArgument((fields.length != 0 ? 1 : 0) != 0, (Object)"At least one field needs to be sharding key");
        Preconditions.checkArgument((fields.length == 1 ? 1 : 0) != 0, (Object)"Only one field can be sharding key");
        this.keyField = fields[0];
        if (!this.keyField.isAccessible()) {
            try {
                this.keyField.setAccessible(true);
            }
            catch (SecurityException e) {
                log.error("Error making key field accessible please use a public method and mark that as LookupKey", (Throwable)e);
                throw new IllegalArgumentException("Invalid class, DAO cannot be created.", e);
            }
        }
        Preconditions.checkArgument((boolean)ClassUtils.isAssignable(this.keyField.getType(), String.class), (Object)"Key field must be a string");
    }

    public Optional<T> get(String key) throws Exception {
        return Optional.ofNullable(this.get(key, t -> t));
    }

    public <U> U get(String key, Function<T, U> handler) throws Exception {
        int shardId = ShardCalculator.shardId(this.shardManager, this.bucketIdExtractor, key);
        LookupDaoPriv dao = this.daos.get(shardId);
        return Transactions.execute(dao.sessionFactory, true, dao::get, key, handler);
    }

    public boolean exists(String key) throws Exception {
        return this.get(key).isPresent();
    }

    public Optional<T> save(T entity) throws Exception {
        return Optional.ofNullable(this.save(entity, t -> t));
    }

    public <U> U save(T entity, Function<T, U> handler) throws Exception {
        String key = this.keyField.get(entity).toString();
        int shardId = ShardCalculator.shardId(this.shardManager, this.bucketIdExtractor, key);
        log.debug("Saving entity of type {} with key {} to shard {}", new Object[]{this.entityClass.getSimpleName(), key, shardId});
        LookupDaoPriv dao = this.daos.get(shardId);
        return Transactions.execute(dao.sessionFactory, false, dao::save, entity, handler);
    }

    public boolean updateInLock(String id, Function<Optional<T>, T> updater) {
        int shardId = ShardCalculator.shardId(this.shardManager, this.bucketIdExtractor, id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.updateImpl(id, dao::getLockedForWrite, updater, dao);
    }

    public boolean update(String id, Function<Optional<T>, T> updater) {
        int shardId = ShardCalculator.shardId(this.shardManager, this.bucketIdExtractor, id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.updateImpl(id, dao::get, updater, dao);
    }

    private boolean updateImpl(String id, Function<String, T> getter, Function<Optional<T>, T> updater, LookupDaoPriv dao) {
        try {
            return Transactions.execute(dao.sessionFactory, true, getter, id, entity -> {
                Object newEntity = updater.apply(Optional.ofNullable(entity));
                if (null == newEntity) {
                    return false;
                }
                dao.update(newEntity);
                return true;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating entity: " + id, e);
        }
    }

    public LockedContext<T> lockAndGetExecutor(String id) {
        int shardId = ShardCalculator.shardId(this.shardManager, this.bucketIdExtractor, id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return new LockedContext<String>(shardId, dao.sessionFactory, (Function<String, String>)((Function<String, Object>)dao::getLockedForWrite), id);
    }

    public LockedContext<T> saveAndGetExecutor(T entity) {
        String id;
        try {
            id = this.keyField.get(entity).toString();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        int shardId = ShardCalculator.shardId(this.shardManager, this.bucketIdExtractor, id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return new LockedContext<Object>(shardId, dao.sessionFactory, dao::save, entity);
    }

    public List<T> scatterGather(DetachedCriteria criteria) {
        return this.daos.stream().map(dao -> {
            try {
                return Transactions.execute(((LookupDaoPriv)dao).sessionFactory, true, dao::select, criteria);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<T> get(List<String> keys) {
        Map lookupKeysGroupByShards = keys.stream().collect(Collectors.groupingBy(key -> ShardCalculator.shardId(this.shardManager, this.bucketIdExtractor, key), Collectors.toList()));
        return lookupKeysGroupByShards.keySet().stream().map(shardId -> {
            try {
                DetachedCriteria criteria = DetachedCriteria.forClass(this.entityClass).add(Restrictions.in((String)this.keyField.getName(), (Collection)((Collection)lookupKeysGroupByShards.get(shardId))));
                return Transactions.execute(this.daos.get((int)shardId).sessionFactory, true, this.daos.get((int)shardId)::select, criteria);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected Field getKeyField() {
        return this.keyField;
    }

    public static class LockedContext<T> {
        private final int shardId;
        private final SessionFactory sessionFactory;
        private Function<String, T> function;
        private Function<T, T> saver;
        private T entity;
        private String key;
        private List<Function<T, Void>> operations = Lists.newArrayList();
        private final Mode mode;

        public LockedContext(int shardId, SessionFactory sessionFactory, Function<String, T> getter, String key) {
            this.shardId = shardId;
            this.sessionFactory = sessionFactory;
            this.function = getter;
            this.key = key;
            this.mode = Mode.READ;
        }

        public LockedContext(int shardId, SessionFactory sessionFactory, Function<T, T> saver, T entity) {
            this.shardId = shardId;
            this.sessionFactory = sessionFactory;
            this.saver = saver;
            this.entity = entity;
            this.mode = Mode.INSERT;
        }

        public LockedContext<T> mutate(Mutator<T> mutator) {
            return this.apply(parent -> {
                mutator.mutator(parent);
                return null;
            });
        }

        public LockedContext<T> apply(Function<T, Void> handler) {
            this.operations.add(handler);
            return this;
        }

        public <U> LockedContext<T> save(RelationalDao<U> relationalDao, Function<T, U> entityGenerator) {
            return this.apply(parent -> {
                try {
                    Object entity = entityGenerator.apply(parent);
                    relationalDao.save(this, entity);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }

        public <U> LockedContext<T> saveAll(RelationalDao<U> relationalDao, Function<T, List<U>> entityGenerator) {
            return this.apply(parent -> {
                try {
                    List entities = (List)entityGenerator.apply(parent);
                    for (Object entity : entities) {
                        relationalDao.save(this, entity);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }

        public <U> LockedContext<T> save(RelationalDao<U> relationalDao, U entity, Function<U, U> handler) {
            return this.apply(parent -> {
                try {
                    relationalDao.save(this, entity, handler);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }

        public <U> LockedContext<T> update(RelationalDao<U> relationalDao, Object id, Function<U, U> handler) {
            return this.apply(parent -> {
                try {
                    relationalDao.update(this, id, handler);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }

        public LockedContext<T> filter(Predicate<T> predicate) {
            return this.filter(predicate, new IllegalArgumentException("Predicate check failed"));
        }

        public LockedContext<T> filter(Predicate<T> predicate, RuntimeException failureException) {
            return this.apply(parent -> {
                boolean result = predicate.test(parent);
                if (!result) {
                    throw failureException;
                }
                return null;
            });
        }

        public void execute() {
            TransactionHandler transactionHandler = new TransactionHandler(this.sessionFactory, false);
            transactionHandler.beforeStart();
            try {
                Object result = this.generateEntity();
                this.operations.forEach(operation -> {
                    Void cfr_ignored_0 = (Void)operation.apply(result);
                });
                transactionHandler.afterEnd();
            }
            catch (Exception e) {
                transactionHandler.onError();
                throw e;
            }
        }

        private T generateEntity() {
            T result = null;
            switch (this.mode) {
                case READ: {
                    result = this.function.apply(this.key);
                    if (result != null) break;
                    throw new RuntimeException("Entity doesn't exist for key: " + this.key);
                }
                case INSERT: {
                    result = this.saver.apply(this.entity);
                    break;
                }
            }
            return result;
        }

        public int getShardId() {
            return this.shardId;
        }

        public SessionFactory getSessionFactory() {
            return this.sessionFactory;
        }

        public Function<String, T> getFunction() {
            return this.function;
        }

        public Function<T, T> getSaver() {
            return this.saver;
        }

        public T getEntity() {
            return this.entity;
        }

        public String getKey() {
            return this.key;
        }

        public List<Function<T, Void>> getOperations() {
            return this.operations;
        }

        public Mode getMode() {
            return this.mode;
        }

        static enum Mode {
            READ,
            INSERT;

        }

        @FunctionalInterface
        public static interface Mutator<T> {
            public void mutator(T var1);
        }
    }

    private final class LookupDaoPriv
    extends AbstractDAO<T> {
        private final SessionFactory sessionFactory;

        public LookupDaoPriv(SessionFactory sessionFactory) {
            super(sessionFactory);
            this.sessionFactory = sessionFactory;
        }

        T get(String lookupKey) {
            return this.getLocked(lookupKey, LockMode.READ);
        }

        T getLockedForWrite(String lookupKey) {
            return this.getLocked(lookupKey, LockMode.UPGRADE_NOWAIT);
        }

        T getLocked(String lookupKey, LockMode lockMode) {
            return this.uniqueResult(this.currentSession().createCriteria(LookupDao.this.entityClass).add((Criterion)Restrictions.eq((String)LookupDao.this.keyField.getName(), (Object)lookupKey)).setLockMode(lockMode));
        }

        T save(T entity) {
            return this.persist(entity);
        }

        void update(T entity) {
            this.currentSession().evict(entity);
            this.currentSession().update(entity);
        }

        List<T> select(DetachedCriteria criteria) {
            return this.list(criteria.getExecutableCriteria(this.currentSession()));
        }
    }
}

