/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.sharding;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardManager {
    private static final Logger log = LoggerFactory.getLogger(ShardManager.class);
    public static final int MIN_BUCKET = 0;
    public static final int MAX_BUCKET = 999;
    private RangeMap<Integer, Integer> buckets = TreeRangeMap.create();

    public ShardManager(int numBuckets) {
        int interval = 999 / numBuckets;
        int shardCounter = 0;
        boolean endReached = false;
        int start = 0;
        while (!endReached) {
            int end = start + interval - 1;
            endReached = 999 - start <= 2 * interval;
            end = endReached ? end + 999 - end : end;
            this.buckets.put(Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)), (Object)shardCounter);
            start += interval;
            ++shardCounter;
        }
        log.info("Buckets to shard allocation: {}", this.buckets);
    }

    public int shardForBucket(int bucketId) {
        Preconditions.checkArgument((bucketId >= 0 && bucketId <= 999 ? 1 : 0) != 0, (Object)"Bucket id can only be in the range of [1-1000] (inclusive)");
        Map.Entry entry = this.buckets.getEntry((Comparable)Integer.valueOf(bucketId));
        if (null == entry) {
            throw new IllegalAccessError("Bucket not mapped to any shard");
        }
        return (Integer)entry.getValue();
    }

    public static ShardManagerBuilder builder() {
        return new ShardManagerBuilder();
    }

    public String toString() {
        return "ShardManager(buckets=" + this.buckets + ")";
    }

    public static class ShardManagerBuilder {
        private int numBuckets;

        ShardManagerBuilder() {
        }

        public ShardManagerBuilder numBuckets(int numBuckets) {
            this.numBuckets = numBuckets;
            return this;
        }

        public ShardManager build() {
            return new ShardManager(this.numBuckets);
        }

        public String toString() {
            return "ShardManager.ShardManagerBuilder(numBuckets=" + this.numBuckets + ")";
        }
    }
}

