/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.dao;

import com.google.common.base.Preconditions;
import io.dropwizard.hibernate.AbstractDAO;
import io.dropwizard.sharding.sharding.ShardManager;
import io.dropwizard.sharding.utils.ShardCalculator;
import io.dropwizard.sharding.utils.Transactions;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Id;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationalDao<T> {
    private static final Logger log = LoggerFactory.getLogger(RelationalDao.class);
    private List<LookupDaoPriv> daos;
    private final Class<T> entityClass;
    private final ShardManager shardManager;
    private final Field keyField;

    public RelationalDao(List<SessionFactory> sessionFactories, Class<T> entityClass, ShardManager shardManager) {
        this.shardManager = shardManager;
        this.daos = sessionFactories.stream().map(x$0 -> new LookupDaoPriv((SessionFactory)x$0)).collect(Collectors.toList());
        this.entityClass = entityClass;
        Field[] fields = FieldUtils.getFieldsWithAnnotation(entityClass, Id.class);
        Preconditions.checkArgument((fields.length != 0 ? 1 : 0) != 0, (Object)"A field needs to be designated as @Id");
        Preconditions.checkArgument((fields.length == 1 ? 1 : 0) != 0, (Object)"Only one field can be designated as @Id");
        this.keyField = fields[0];
        if (!this.keyField.isAccessible()) {
            try {
                this.keyField.setAccessible(true);
            }
            catch (SecurityException e) {
                log.error("Error making key field accessible please use a public method and mark that as @Id", (Throwable)e);
                throw new IllegalArgumentException("Invalid class, DAO cannot be created.", e);
            }
        }
    }

    public Optional<T> get(String parentKey, Object key) throws Exception {
        return Optional.ofNullable(this.get(parentKey, key, t -> t));
    }

    public <U> U get(String parentKey, Object key, Function<T, U> function) throws Exception {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        return Transactions.execute(dao.sessionFactory, true, dao::get, key, function);
    }

    public Optional<T> save(String parentKey, T entity) throws Exception {
        return Optional.ofNullable(this.save(parentKey, entity, t -> t));
    }

    public <U> U save(String parentKey, T entity, Function<T, U> handler) throws Exception {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        return Transactions.execute(dao.sessionFactory, false, dao::save, entity, handler);
    }

    public boolean update(String parentKey, Object id, Function<T, T> updater) {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        try {
            return Transactions.execute(dao.sessionFactory, true, dao::get, id, entity -> {
                if (null == entity) {
                    return false;
                }
                Object newEntity = updater.apply(entity);
                if (null == newEntity) {
                    return false;
                }
                dao.update(entity, newEntity);
                return true;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating entity: " + id, e);
        }
    }

    public boolean update(String parentKey, DetachedCriteria criteria, Function<T, T> updater) {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        try {
            SelectParamPriv selectParam = SelectParamPriv.builder().criteria(criteria).start(0).numRows(1).build();
            return Transactions.execute(dao.sessionFactory, true, dao::select, selectParam, entityList -> {
                if (entityList == null || entityList.isEmpty()) {
                    return false;
                }
                Object oldEntity = entityList.get(0);
                if (null == oldEntity) {
                    return false;
                }
                Object newEntity = updater.apply(oldEntity);
                if (null == newEntity) {
                    return false;
                }
                dao.update(oldEntity, newEntity);
                return true;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating entity with criteria: " + criteria, e);
        }
    }

    public boolean updateAll(String parentKey, DetachedCriteria criteria, Function<T, T> updater) {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        try {
            SelectParamPriv selectParam = SelectParamPriv.builder().criteria(criteria).start(0).numRows(1).build();
            return Transactions.execute(dao.sessionFactory, true, dao::select, selectParam, entityList -> {
                if (entityList == null || entityList.isEmpty()) {
                    return false;
                }
                for (Object oldEntity : entityList) {
                    if (null == oldEntity) {
                        return false;
                    }
                    Object newEntity = updater.apply(oldEntity);
                    if (null == newEntity) {
                        return false;
                    }
                    dao.update(oldEntity, newEntity);
                }
                return true;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating entity with criteria: " + criteria, e);
        }
    }

    public List<T> select(String parentKey, DetachedCriteria criteria) throws Exception {
        return this.select(parentKey, criteria, 0, 10);
    }

    public List<T> select(String parentKey, DetachedCriteria criteria, int first, int numResults) throws Exception {
        return this.select(parentKey, criteria, first, numResults, t -> t);
    }

    public <U> U select(String parentKey, DetachedCriteria criteria, Function<List<T>, U> handler) throws Exception {
        return this.select(parentKey, criteria, 0, 10, handler);
    }

    public <U> U select(String parentKey, DetachedCriteria criteria, int first, int numResults, Function<List<T>, U> handler) throws Exception {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        SelectParamPriv selectParam = SelectParamPriv.builder().criteria(criteria).start(first).numRows(numResults).build();
        return Transactions.execute(dao.sessionFactory, true, dao::select, selectParam, handler);
    }

    public long count(String parentKey, DetachedCriteria criteria) throws Exception {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        return Transactions.execute(dao.sessionFactory, true, dao::count, criteria);
    }

    public boolean exists(String parentKey, Object key) throws Exception {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        Optional<Object> result = Transactions.executeAndResolve(dao.sessionFactory, true, dao::get, key);
        return result.isPresent();
    }

    public List<T> scatterGather(DetachedCriteria criteria) {
        return this.daos.stream().map(dao -> {
            try {
                SelectParamPriv selectParam = SelectParamPriv.builder().criteria(criteria).start(0).numRows(10).build();
                return Transactions.execute(((LookupDaoPriv)dao).sessionFactory, true, dao::select, selectParam);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static class SelectParamPriv {
        DetachedCriteria criteria;
        int start;
        int numRows;

        SelectParamPriv(DetachedCriteria criteria, int start, int numRows) {
            this.criteria = criteria;
            this.start = start;
            this.numRows = numRows;
        }

        public static SelectParamPrivBuilder builder() {
            return new SelectParamPrivBuilder();
        }

        public static class SelectParamPrivBuilder {
            private DetachedCriteria criteria;
            private int start;
            private int numRows;

            SelectParamPrivBuilder() {
            }

            public SelectParamPrivBuilder criteria(DetachedCriteria criteria) {
                this.criteria = criteria;
                return this;
            }

            public SelectParamPrivBuilder start(int start) {
                this.start = start;
                return this;
            }

            public SelectParamPrivBuilder numRows(int numRows) {
                this.numRows = numRows;
                return this;
            }

            public SelectParamPriv build() {
                return new SelectParamPriv(this.criteria, this.start, this.numRows);
            }

            public String toString() {
                return "RelationalDao.SelectParamPriv.SelectParamPrivBuilder(criteria=" + this.criteria + ", start=" + this.start + ", numRows=" + this.numRows + ")";
            }
        }
    }

    private final class LookupDaoPriv
    extends AbstractDAO<T> {
        private final SessionFactory sessionFactory;

        public LookupDaoPriv(SessionFactory sessionFactory) {
            super(sessionFactory);
            this.sessionFactory = sessionFactory;
        }

        T get(Object lookupKey) {
            return this.uniqueResult(this.currentSession().createCriteria(RelationalDao.this.entityClass).add((Criterion)Restrictions.eq((String)RelationalDao.this.keyField.getName(), (Object)lookupKey)));
        }

        T save(T entity) {
            return this.persist(entity);
        }

        void update(T oldEntity, T entity) {
            this.currentSession().evict(oldEntity);
            this.currentSession().update(entity);
        }

        List<T> select(SelectParamPriv selectParam) {
            Criteria criteria = selectParam.criteria.getExecutableCriteria(this.currentSession());
            criteria.setFirstResult(selectParam.start);
            criteria.setMaxResults(selectParam.numRows);
            return this.list(criteria);
        }

        long count(DetachedCriteria criteria) {
            return (Long)criteria.getExecutableCriteria(this.currentSession()).setProjection(Projections.rowCount()).uniqueResult();
        }
    }
}

