/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.utils;

import io.dropwizard.sharding.utils.TransactionHandler;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.SessionFactory;

public class Transactions {
    private Transactions() {
    }

    public static <T, U> Optional<T> executeAndResolve(SessionFactory sessionFactory, Function<U, T> function, U arg) throws Exception {
        return Transactions.executeAndResolve(sessionFactory, false, function, arg);
    }

    public static <T, U> Optional<T> executeAndResolve(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg) throws Exception {
        T result = Transactions.execute(sessionFactory, readOnly, function, arg);
        if (null == result) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public static <T, U> T execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg) throws Exception {
        return (T)Transactions.execute(sessionFactory, readOnly, function, arg, t -> t);
    }

    public static <T, U, V> V execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg, Function<T, V> handler) throws Exception {
        return Transactions.execute(sessionFactory, readOnly, function, arg, handler, true);
    }

    public static <T, U, V> V execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg, Function<T, V> handler, boolean completeTransaction) throws Exception {
        TransactionHandler transactionHandler = new TransactionHandler(sessionFactory, readOnly);
        if (completeTransaction) {
            transactionHandler.beforeStart();
        }
        try {
            T result = function.apply(arg);
            V returnValue = handler.apply(result);
            if (completeTransaction) {
                transactionHandler.afterEnd();
            }
            return returnValue;
        }
        catch (Exception e) {
            if (completeTransaction) {
                transactionHandler.onError();
            }
            throw e;
        }
    }
}

