/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.utils;

import io.dropwizard.sharding.sharding.impl.ConsistentHashBucketIdExtractor;
import io.dropwizard.sharding.sharding.impl.RandomBucketIdExtractor;

public class BucketExtractors {
    private static final RandomBucketIdExtractor<String> RANDOM_EXTRACTOR = new RandomBucketIdExtractor();
    private static final ConsistentHashBucketIdExtractor<String> HASHING_EXTRACTOR = new ConsistentHashBucketIdExtractor();

    private BucketExtractors() {
    }

    public static int random(String key) {
        return RANDOM_EXTRACTOR.bucketId(key);
    }

    public static int hashed(String key) {
        return HASHING_EXTRACTOR.bucketId(key);
    }
}

