/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.riemann;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.riemann.Riemann;
import com.codahale.metrics.riemann.RiemannReporter;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.riemann.RiemannConfig;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RiemannBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(RiemannBundle.class);
    private static Riemann riemann;
    private static RiemannReporter riemannReporter;

    public abstract RiemannConfig getRiemannConfiguration(T var1);

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) {
        environment.lifecycle().manage(new Managed((Configuration)configuration, environment){
            final /* synthetic */ Configuration val$configuration;
            final /* synthetic */ Environment val$environment;
            {
                this.val$configuration = configuration;
                this.val$environment = environment;
            }

            public void start() throws Exception {
                if (riemann == null) {
                    RiemannConfig riemannConfig = RiemannBundle.this.getRiemannConfiguration(this.val$configuration);
                    try {
                        riemann = new Riemann(riemannConfig.getHost(), Integer.valueOf(riemannConfig.getPort()));
                        ImmutableList tags = ImmutableList.builder().add((Object)riemannConfig.getNamespace()).add((Object)riemannConfig.getEnvironment()).add((Object)riemannConfig.getService()).addAll(riemannConfig.getTags()).build();
                        RiemannReporter.Builder builder = RiemannReporter.forRegistry((MetricRegistry)this.val$environment.metrics()).tags((Collection)tags).prefixedWith(Joiner.on((String)".").join((Object)riemannConfig.getNamespace(), (Object)riemannConfig.getEnvironment(), new Object[]{riemannConfig.getService()})).useSeparator(".").convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS);
                        riemannReporter = builder.build(riemann);
                        riemannReporter.start((long)riemannConfig.getPollingInterval(), TimeUnit.SECONDS);
                        log.info("Started Riemann metrics reporter on {}:{} with tags: {}", new Object[]{riemannConfig.getHost(), riemannConfig.getPort(), Joiner.on((String)",").join((Iterable)tags)});
                    }
                    catch (IOException e) {
                        log.error("Error starting Riemann reporter", (Throwable)e);
                    }
                }
            }

            public void stop() throws Exception {
                if (riemannReporter != null) {
                    riemannReporter.stop();
                }
                if (riemann != null) {
                    riemann.close();
                }
            }
        });
    }
}

