/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.riemann;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RiemannConfig {
    private String host;
    private int port;
    private String namespace;
    private String service;
    private String environment;
    private int pollingInterval = 30;
    private List<String> tags;

    public static RiemannConfigBuilder builder() {
        return new RiemannConfigBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getService() {
        return this.service;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RiemannConfig)) {
            return false;
        }
        RiemannConfig other = (RiemannConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$service = this.getService();
        String other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        if (this.getPollingInterval() != other.getPollingInterval()) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RiemannConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        result = result * 59 + this.getPollingInterval();
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "RiemannConfig(host=" + this.getHost() + ", port=" + this.getPort() + ", namespace=" + this.getNamespace() + ", service=" + this.getService() + ", environment=" + this.getEnvironment() + ", pollingInterval=" + this.getPollingInterval() + ", tags=" + this.getTags() + ")";
    }

    @ConstructorProperties(value={"host", "port", "namespace", "service", "environment", "pollingInterval", "tags"})
    public RiemannConfig(String host, int port, String namespace, String service, String environment, int pollingInterval, List<String> tags) {
        this.host = host;
        this.port = port;
        this.namespace = namespace;
        this.service = service;
        this.environment = environment;
        this.pollingInterval = pollingInterval;
        this.tags = tags;
    }

    public RiemannConfig() {
    }

    public static class RiemannConfigBuilder {
        private String host;
        private int port;
        private String namespace;
        private String service;
        private String environment;
        private int pollingInterval;
        private ArrayList<String> tags;

        RiemannConfigBuilder() {
        }

        public RiemannConfigBuilder host(String host) {
            this.host = host;
            return this;
        }

        public RiemannConfigBuilder port(int port) {
            this.port = port;
            return this;
        }

        public RiemannConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RiemannConfigBuilder service(String service) {
            this.service = service;
            return this;
        }

        public RiemannConfigBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public RiemannConfigBuilder pollingInterval(int pollingInterval) {
            this.pollingInterval = pollingInterval;
            return this;
        }

        public RiemannConfigBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public RiemannConfigBuilder tags(Collection<? extends String> tags) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public RiemannConfig build() {
            List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            return new RiemannConfig(this.host, this.port, this.namespace, this.service, this.environment, this.pollingInterval, tags);
        }

        public String toString() {
            return "RiemannConfig.RiemannConfigBuilder(host=" + this.host + ", port=" + this.port + ", namespace=" + this.namespace + ", service=" + this.service + ", environment=" + this.environment + ", pollingInterval=" + this.pollingInterval + ", tags=" + this.tags + ")";
        }
    }
}

