/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.resource;

import com.codahale.metrics.annotation.Metered;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.dropwizard.revolver.base.core.RevolverAckMessage;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverCallbackResponses;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.base.core.RevolverRequestStateResponse;
import io.dropwizard.revolver.exception.RevolverException;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import io.dropwizard.revolver.util.HeaderUtil;
import io.dropwizard.revolver.util.ResponseTransformationUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/revolver")
@Singleton
@Api(value="MailBox", description="Revolver gateway api for interacting mailbox requests")
public class RevolverMailboxResource {
    private static final Logger log = LoggerFactory.getLogger(RevolverMailboxResource.class);
    private static final RevolverException NOT_FOUND_ERROR = RevolverException.builder().status(Response.Status.NOT_FOUND.getStatusCode()).message("Not found").errorCode("R002").build();
    private static final RevolverException SERVER_ERROR = RevolverException.builder().status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).errorCode("R001").message("Oops! Something went wrong!").build();
    private PersistenceProvider persistenceProvider;
    private ObjectMapper jsonObjectMapper;
    private ObjectMapper msgPackObjectMapper;
    private Map<String, RevolverHttpApiConfig> apiConfig;

    @Path(value="/v1/request/status/{requestId}")
    @GET
    @Metered
    @ApiOperation(value="Get the status of the request in the mailbox")
    @Produces(value={"application/json", "application/msgpack", "application/xml", "text/html"})
    public Response requestStatus(@PathParam(value="requestId") String requestId, @Context HttpHeaders headers) throws RevolverException {
        try {
            RevolverRequestState state = this.persistenceProvider.requestState(requestId);
            if (state == null) {
                throw NOT_FOUND_ERROR;
            }
            RevolverRequestStateResponse response = RevolverRequestStateResponse.builder().requestId(requestId).state(state.name()).build();
            if (headers.getAcceptableMediaTypes().size() == 0) {
                return Response.ok((Object)ResponseTransformationUtil.transform(response, "application/json", this.jsonObjectMapper, this.msgPackObjectMapper), (String)"application/json").build();
            }
            return Response.ok((Object)ResponseTransformationUtil.transform(response, ((MediaType)headers.getAcceptableMediaTypes().get(0)).toString(), this.jsonObjectMapper, this.msgPackObjectMapper), (String)((MediaType)headers.getAcceptableMediaTypes().get(0)).toString()).build();
        }
        catch (Exception e) {
            log.error("Error getting request state", (Throwable)e);
            throw SERVER_ERROR;
        }
    }

    @Path(value="/v1/request/ack/{requestId}")
    @POST
    @Metered
    @ApiOperation(value="Send ack for a request so that the mailbox message can be marked as read")
    @Produces(value={"application/json", "application/msgpack", "application/xml", "text/html"})
    public Response ack(@PathParam(value="requestId") String requestId) throws RevolverException {
        try {
            RevolverRequestState state = this.persistenceProvider.requestState(requestId);
            if (state == null) {
                throw NOT_FOUND_ERROR;
            }
            switch (state) {
                case RESPONDED: 
                case ERROR: {
                    RevolverCallbackRequest callbackRequest = this.persistenceProvider.request(requestId);
                    List ttl = callbackRequest.getHeaders().getOrDefault("X-MAILBOX-TTL", Collections.emptyList());
                    int mailboxTtl = HeaderUtil.getTTL(callbackRequest);
                    if (!ttl.isEmpty()) {
                        mailboxTtl = Integer.parseInt((String)ttl.get(0));
                    }
                    this.persistenceProvider.setRequestState(requestId, RevolverRequestState.READ, mailboxTtl);
                    return Response.accepted().build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            log.error("Error getting request state", (Throwable)e);
            throw SERVER_ERROR;
        }
    }

    @Path(value="/v1/request/{requestId}")
    @GET
    @Metered
    @ApiOperation(value="Get the request in the mailbox")
    @Produces(value={"application/json", "application/msgpack", "application/xml", "text/html"})
    public Response request(@PathParam(value="requestId") String requestId, @Context HttpHeaders headers) throws RevolverException {
        try {
            RevolverCallbackRequest callbackRequest = this.persistenceProvider.request(requestId);
            if (callbackRequest == null) {
                throw NOT_FOUND_ERROR;
            }
            if (headers.getAcceptableMediaTypes().size() == 0) {
                return Response.ok((Object)ResponseTransformationUtil.transform(callbackRequest, "application/json", this.jsonObjectMapper, this.msgPackObjectMapper), (String)"application/json").build();
            }
            return Response.ok((Object)ResponseTransformationUtil.transform(callbackRequest, ((MediaType)headers.getAcceptableMediaTypes().get(0)).toString(), this.jsonObjectMapper, this.msgPackObjectMapper), (String)((MediaType)headers.getAcceptableMediaTypes().get(0)).toString()).build();
        }
        catch (Exception e) {
            log.error("Error getting request", (Throwable)e);
            throw SERVER_ERROR;
        }
    }

    @Path(value="/v1/response/{requestId}")
    @GET
    @Metered
    @ApiOperation(value="Get the response for a request in the mailbox")
    @Produces(value={"application/json", "application/msgpack", "application/xml", "text/html"})
    public Response response(@PathParam(value="requestId") String requestId) throws RevolverException {
        try {
            RevolverCallbackResponse callbackResponse = this.persistenceProvider.response(requestId);
            if (callbackResponse == null) {
                throw NOT_FOUND_ERROR;
            }
            Response.ResponseBuilder response = Response.status((int)callbackResponse.getStatusCode()).entity((Object)callbackResponse.getBody());
            callbackResponse.getHeaders().forEach((k, v) -> v.forEach(h -> response.header(k, h)));
            return response.build();
        }
        catch (Exception e) {
            log.error("Error getting response", (Throwable)e);
            throw SERVER_ERROR;
        }
    }

    @Path(value="/v2/response/{requestId}")
    @GET
    @Metered
    @ApiOperation(value="Get the response for a request in the mailbox")
    @Produces(value={"application/json", "application/msgpack", "application/xml", "text/html"})
    public Response getResponse(@PathParam(value="requestId") String requestId, @Context HttpHeaders headers) throws RevolverException {
        try {
            RevolverRequestState state = this.persistenceProvider.requestState(requestId);
            if (state == null) {
                throw NOT_FOUND_ERROR;
            }
            switch (state) {
                case RESPONDED: {
                    RevolverCallbackResponse callbackResponse = this.persistenceProvider.response(requestId);
                    if (callbackResponse == null) {
                        throw NOT_FOUND_ERROR;
                    }
                    Response.ResponseBuilder response = Response.status((int)callbackResponse.getStatusCode()).entity((Object)callbackResponse.getBody());
                    callbackResponse.getHeaders().forEach((k, v) -> v.forEach(h -> response.header(k, h)));
                    return response.build();
                }
            }
            RevolverRequestStateResponse revolverRequestStateResponse = RevolverRequestStateResponse.builder().requestId(requestId).state(state.name()).build();
            double retryAfter = this.getRetryAfter(requestId);
            if (headers.getAcceptableMediaTypes().size() == 0) {
                return Response.ok((Object)ResponseTransformationUtil.transform(revolverRequestStateResponse, "application/json", this.jsonObjectMapper, this.msgPackObjectMapper), (String)"application/json").header("X-RETRY-AFTER", (Object)retryAfter).build();
            }
            return Response.ok((Object)ResponseTransformationUtil.transform(revolverRequestStateResponse, ((MediaType)headers.getAcceptableMediaTypes().get(0)).toString(), this.jsonObjectMapper, this.msgPackObjectMapper), (String)((MediaType)headers.getAcceptableMediaTypes().get(0)).toString()).build();
        }
        catch (Exception e) {
            log.error("Error getting response", (Throwable)e);
            throw SERVER_ERROR;
        }
    }

    private double getRetryAfter(@PathParam(value="requestId") String requestId) {
        RevolverCallbackRequest revolverCallbackRequest = this.persistenceProvider.request(requestId);
        RevolverHttpApiConfig revolverHttpApiConfig = this.apiConfig.get(revolverCallbackRequest.getApi());
        double retryAfter = revolverHttpApiConfig == null || revolverHttpApiConfig.getApiLatencyConfig() == null ? -1.0 : revolverHttpApiConfig.getApiLatencyConfig().getLatency();
        return retryAfter;
    }

    @Path(value="/v1/requests")
    @GET
    @Metered
    @ApiOperation(value="Get all the requests in the mailbox")
    @Produces(value={"application/json", "application/msgpack", "application/xml", "text/html"})
    public Response requests(@HeaderParam(value="X-MAILBOX-ID") String mailboxId, @Context HttpHeaders headers) throws RevolverException {
        try {
            List<RevolverCallbackRequest> callbackRequests = this.persistenceProvider.requests(mailboxId);
            if (callbackRequests == null) {
                throw NOT_FOUND_ERROR;
            }
            if (headers.getAcceptableMediaTypes().size() == 0) {
                return Response.ok((Object)ResponseTransformationUtil.transform(callbackRequests, "application/json", this.jsonObjectMapper, this.msgPackObjectMapper), (String)"application/json").build();
            }
            return Response.ok((Object)ResponseTransformationUtil.transform(callbackRequests, ((MediaType)headers.getAcceptableMediaTypes().get(0)).toString(), this.jsonObjectMapper, this.msgPackObjectMapper), (String)((MediaType)headers.getAcceptableMediaTypes().get(0)).toString()).build();
        }
        catch (Exception e) {
            log.error("Error getting requests", (Throwable)e);
            throw SERVER_ERROR;
        }
    }

    @Path(value="/v1/responses")
    @GET
    @Metered
    @ApiOperation(value="Get all the responses in the mailbox")
    @Produces(value={"application/json", "application/msgpack", "application/xml", "text/html"})
    public Response responses(@HeaderParam(value="X-MAILBOX-ID") String mailboxId, @Context HttpHeaders headers) throws RevolverException {
        try {
            if (Strings.isNullOrEmpty((String)mailboxId)) {
                throw RevolverException.builder().status(Response.Status.BAD_REQUEST.getStatusCode()).message("Invalid Mailbox Id").errorCode("R003").build();
            }
            List<RevolverCallbackResponses> callbackResponses = this.persistenceProvider.responses(mailboxId);
            if (callbackResponses == null) {
                throw NOT_FOUND_ERROR;
            }
            if (headers.getAcceptableMediaTypes().size() == 0) {
                return Response.ok((Object)ResponseTransformationUtil.transform(callbackResponses, "application/json", this.jsonObjectMapper, this.msgPackObjectMapper), (String)"application/json").build();
            }
            return Response.ok((Object)ResponseTransformationUtil.transform(callbackResponses, ((MediaType)headers.getAcceptableMediaTypes().get(0)).toString(), this.jsonObjectMapper, this.msgPackObjectMapper), (String)((MediaType)headers.getAcceptableMediaTypes().get(0)).toString()).build();
        }
        catch (Exception e) {
            log.error("Error getting responses", (Throwable)e);
            throw RevolverException.builder().status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).errorCode("R001").message(ExceptionUtils.getRootCause((Throwable)e).getMessage()).build();
        }
    }

    @Path(value="/v1/message/persist")
    @POST
    @Metered
    @ApiOperation(value="Persist a request in the mailbox")
    @Produces(value={"application/json", "application/msgpack", "application/xml", "text/html"})
    public Response persistRequest(@Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws RevolverException {
        try {
            String requestId = headers.getHeaderString("X-REQUEST-ID");
            String mailBoxId = headers.getHeaderString("X-MAILBOX-ID");
            this.persistenceProvider.saveRequest(requestId, mailBoxId, RevolverCallbackRequest.builder().api("persist").mode("POLLING").callbackUri(null).method("POST").service("mailbox").path(uriInfo.getPath()).headers((Map<String, List<String>>)headers.getRequestHeaders()).queryParams((Map<String, List<String>>)uriInfo.getQueryParameters()).body(body).build());
            RevolverAckMessage response = RevolverAckMessage.builder().requestId(requestId).acceptedAt(Instant.now().toEpochMilli()).build();
            if (headers.getAcceptableMediaTypes().size() == 0) {
                return Response.ok((Object)ResponseTransformationUtil.transform(response, "application/json", this.jsonObjectMapper, this.msgPackObjectMapper), (String)"application/json").build();
            }
            return Response.ok((Object)ResponseTransformationUtil.transform(response, ((MediaType)headers.getAcceptableMediaTypes().get(0)).toString(), this.jsonObjectMapper, this.msgPackObjectMapper), (String)((MediaType)headers.getAcceptableMediaTypes().get(0)).toString()).build();
        }
        catch (Exception e) {
            log.error("Error getting responses", (Throwable)e);
            throw SERVER_ERROR;
        }
    }

    public static RevolverMailboxResourceBuilder builder() {
        return new RevolverMailboxResourceBuilder();
    }

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public ObjectMapper getJsonObjectMapper() {
        return this.jsonObjectMapper;
    }

    public ObjectMapper getMsgPackObjectMapper() {
        return this.msgPackObjectMapper;
    }

    public Map<String, RevolverHttpApiConfig> getApiConfig() {
        return this.apiConfig;
    }

    public void setPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }

    public void setJsonObjectMapper(ObjectMapper jsonObjectMapper) {
        this.jsonObjectMapper = jsonObjectMapper;
    }

    public void setMsgPackObjectMapper(ObjectMapper msgPackObjectMapper) {
        this.msgPackObjectMapper = msgPackObjectMapper;
    }

    public void setApiConfig(Map<String, RevolverHttpApiConfig> apiConfig) {
        this.apiConfig = apiConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverMailboxResource)) {
            return false;
        }
        RevolverMailboxResource other = (RevolverMailboxResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PersistenceProvider this$persistenceProvider = this.getPersistenceProvider();
        PersistenceProvider other$persistenceProvider = other.getPersistenceProvider();
        if (this$persistenceProvider == null ? other$persistenceProvider != null : !this$persistenceProvider.equals(other$persistenceProvider)) {
            return false;
        }
        ObjectMapper this$jsonObjectMapper = this.getJsonObjectMapper();
        ObjectMapper other$jsonObjectMapper = other.getJsonObjectMapper();
        if (this$jsonObjectMapper == null ? other$jsonObjectMapper != null : !this$jsonObjectMapper.equals(other$jsonObjectMapper)) {
            return false;
        }
        ObjectMapper this$msgPackObjectMapper = this.getMsgPackObjectMapper();
        ObjectMapper other$msgPackObjectMapper = other.getMsgPackObjectMapper();
        if (this$msgPackObjectMapper == null ? other$msgPackObjectMapper != null : !this$msgPackObjectMapper.equals(other$msgPackObjectMapper)) {
            return false;
        }
        Map<String, RevolverHttpApiConfig> this$apiConfig = this.getApiConfig();
        Map<String, RevolverHttpApiConfig> other$apiConfig = other.getApiConfig();
        return !(this$apiConfig == null ? other$apiConfig != null : !((Object)this$apiConfig).equals(other$apiConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverMailboxResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PersistenceProvider $persistenceProvider = this.getPersistenceProvider();
        result = result * 59 + ($persistenceProvider == null ? 43 : $persistenceProvider.hashCode());
        ObjectMapper $jsonObjectMapper = this.getJsonObjectMapper();
        result = result * 59 + ($jsonObjectMapper == null ? 43 : $jsonObjectMapper.hashCode());
        ObjectMapper $msgPackObjectMapper = this.getMsgPackObjectMapper();
        result = result * 59 + ($msgPackObjectMapper == null ? 43 : $msgPackObjectMapper.hashCode());
        Map<String, RevolverHttpApiConfig> $apiConfig = this.getApiConfig();
        result = result * 59 + ($apiConfig == null ? 43 : ((Object)$apiConfig).hashCode());
        return result;
    }

    public String toString() {
        return "RevolverMailboxResource(persistenceProvider=" + this.getPersistenceProvider() + ", jsonObjectMapper=" + this.getJsonObjectMapper() + ", msgPackObjectMapper=" + this.getMsgPackObjectMapper() + ", apiConfig=" + this.getApiConfig() + ")";
    }

    public RevolverMailboxResource(PersistenceProvider persistenceProvider, ObjectMapper jsonObjectMapper, ObjectMapper msgPackObjectMapper, Map<String, RevolverHttpApiConfig> apiConfig) {
        this.persistenceProvider = persistenceProvider;
        this.jsonObjectMapper = jsonObjectMapper;
        this.msgPackObjectMapper = msgPackObjectMapper;
        this.apiConfig = apiConfig;
    }

    public static class RevolverMailboxResourceBuilder {
        private PersistenceProvider persistenceProvider;
        private ObjectMapper jsonObjectMapper;
        private ObjectMapper msgPackObjectMapper;
        private Map<String, RevolverHttpApiConfig> apiConfig;

        RevolverMailboxResourceBuilder() {
        }

        public RevolverMailboxResourceBuilder persistenceProvider(PersistenceProvider persistenceProvider) {
            this.persistenceProvider = persistenceProvider;
            return this;
        }

        public RevolverMailboxResourceBuilder jsonObjectMapper(ObjectMapper jsonObjectMapper) {
            this.jsonObjectMapper = jsonObjectMapper;
            return this;
        }

        public RevolverMailboxResourceBuilder msgPackObjectMapper(ObjectMapper msgPackObjectMapper) {
            this.msgPackObjectMapper = msgPackObjectMapper;
            return this;
        }

        public RevolverMailboxResourceBuilder apiConfig(Map<String, RevolverHttpApiConfig> apiConfig) {
            this.apiConfig = apiConfig;
            return this;
        }

        public RevolverMailboxResource build() {
            return new RevolverMailboxResource(this.persistenceProvider, this.jsonObjectMapper, this.msgPackObjectMapper, this.apiConfig);
        }

        public String toString() {
            return "RevolverMailboxResource.RevolverMailboxResourceBuilder(persistenceProvider=" + this.persistenceProvider + ", jsonObjectMapper=" + this.jsonObjectMapper + ", msgPackObjectMapper=" + this.msgPackObjectMapper + ", apiConfig=" + this.apiConfig + ")";
        }
    }
}

