/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.config;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.dropwizard.revolver.core.config.HystrixCommandConfig;
import io.dropwizard.revolver.core.config.ThreadPoolGroupConfig;
import io.dropwizard.revolver.core.config.sentinel.SentinelCommandConfig;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true)
public class RevolverServiceConfig {
    protected ThreadPoolGroupConfig threadPoolGroupConfig;
    @NotNull
    @NotBlank
    private String type;
    @NotNull
    @NotBlank
    private String service;
    private String fallbackAddress;
    private HystrixCommandConfig runtime = new HystrixCommandConfig();
    private SentinelCommandConfig sentinelCommandConfig = new SentinelCommandConfig();

    public RevolverServiceConfig(String type, String service, SentinelCommandConfig sentinelCommandConfig) {
        this.type = type;
        this.service = service;
        this.sentinelCommandConfig = sentinelCommandConfig;
    }

    public ThreadPoolGroupConfig getThreadPoolGroupConfig() {
        return this.threadPoolGroupConfig;
    }

    public String getType() {
        return this.type;
    }

    public String getService() {
        return this.service;
    }

    public String getFallbackAddress() {
        return this.fallbackAddress;
    }

    public HystrixCommandConfig getRuntime() {
        return this.runtime;
    }

    public SentinelCommandConfig getSentinelCommandConfig() {
        return this.sentinelCommandConfig;
    }

    public void setThreadPoolGroupConfig(ThreadPoolGroupConfig threadPoolGroupConfig) {
        this.threadPoolGroupConfig = threadPoolGroupConfig;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setFallbackAddress(String fallbackAddress) {
        this.fallbackAddress = fallbackAddress;
    }

    public void setRuntime(HystrixCommandConfig runtime) {
        this.runtime = runtime;
    }

    public void setSentinelCommandConfig(SentinelCommandConfig sentinelCommandConfig) {
        this.sentinelCommandConfig = sentinelCommandConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverServiceConfig)) {
            return false;
        }
        RevolverServiceConfig other = (RevolverServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ThreadPoolGroupConfig this$threadPoolGroupConfig = this.getThreadPoolGroupConfig();
        ThreadPoolGroupConfig other$threadPoolGroupConfig = other.getThreadPoolGroupConfig();
        if (this$threadPoolGroupConfig == null ? other$threadPoolGroupConfig != null : !((Object)this$threadPoolGroupConfig).equals(other$threadPoolGroupConfig)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$service = this.getService();
        String other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        String this$fallbackAddress = this.getFallbackAddress();
        String other$fallbackAddress = other.getFallbackAddress();
        if (this$fallbackAddress == null ? other$fallbackAddress != null : !this$fallbackAddress.equals(other$fallbackAddress)) {
            return false;
        }
        HystrixCommandConfig this$runtime = this.getRuntime();
        HystrixCommandConfig other$runtime = other.getRuntime();
        if (this$runtime == null ? other$runtime != null : !((Object)this$runtime).equals(other$runtime)) {
            return false;
        }
        SentinelCommandConfig this$sentinelCommandConfig = this.getSentinelCommandConfig();
        SentinelCommandConfig other$sentinelCommandConfig = other.getSentinelCommandConfig();
        return !(this$sentinelCommandConfig == null ? other$sentinelCommandConfig != null : !((Object)this$sentinelCommandConfig).equals(other$sentinelCommandConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ThreadPoolGroupConfig $threadPoolGroupConfig = this.getThreadPoolGroupConfig();
        result = result * 59 + ($threadPoolGroupConfig == null ? 43 : ((Object)$threadPoolGroupConfig).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        String $fallbackAddress = this.getFallbackAddress();
        result = result * 59 + ($fallbackAddress == null ? 43 : $fallbackAddress.hashCode());
        HystrixCommandConfig $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : ((Object)$runtime).hashCode());
        SentinelCommandConfig $sentinelCommandConfig = this.getSentinelCommandConfig();
        result = result * 59 + ($sentinelCommandConfig == null ? 43 : ((Object)$sentinelCommandConfig).hashCode());
        return result;
    }

    public RevolverServiceConfig(ThreadPoolGroupConfig threadPoolGroupConfig, String type, String service, String fallbackAddress, HystrixCommandConfig runtime, SentinelCommandConfig sentinelCommandConfig) {
        this.threadPoolGroupConfig = threadPoolGroupConfig;
        this.type = type;
        this.service = service;
        this.fallbackAddress = fallbackAddress;
        this.runtime = runtime;
        this.sentinelCommandConfig = sentinelCommandConfig;
    }

    public RevolverServiceConfig() {
    }

    public String toString() {
        return "RevolverServiceConfig(threadPoolGroupConfig=" + this.getThreadPoolGroupConfig() + ", type=" + this.getType() + ", service=" + this.getService() + ", fallbackAddress=" + this.getFallbackAddress() + ", runtime=" + this.getRuntime() + ", sentinelCommandConfig=" + this.getSentinelCommandConfig() + ")";
    }
}

