/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.SphU;
import io.dropwizard.revolver.core.RevolverCommand;
import io.dropwizard.revolver.core.RevolverContext;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.model.RevolverResponse;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import io.dropwizard.revolver.core.util.RevolverExceptionHelper;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import rx.Observable;

public class SentinelCommandHandler<RequestType extends RevolverRequest, ResponseType extends RevolverResponse, ContextType extends RevolverContext, ServiceConfigurationType extends RevolverServiceConfig, CommandHandlerConfigurationType extends CommandHandlerConfig> {
    private final RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler;
    private final RequestType request;
    private final ContextType context;

    public SentinelCommandHandler(ContextType context, RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler, RequestType request) {
        this.context = context;
        this.handler = handler;
        this.request = request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseType executeSync() throws Exception {
        String resourceName = this.getResourceName(this.handler, this.request);
        try (Entry entry = SphU.entry((String)resourceName);){
            Thread.sleep(5000L);
            ResponseType ResponseType = this.handler.execute(this.context, this.request);
            return ResponseType;
        }
        catch (Throwable throwable) {
            throw this.getException(throwable);
        }
    }

    public CompletableFuture<ResponseType> executeASync() {
        try {
            AsyncEntry entry = SphU.asyncEntry((String)this.getResourceName(this.handler, this.request));
            return CompletableFuture.supplyAsync(() -> {
                try {
                    ResponseType ResponseType = this.handler.execute(this.context, this.request);
                    return ResponseType;
                }
                catch (Throwable throwable) {
                    throw this.getException(throwable);
                }
                finally {
                    entry.exit();
                }
            });
        }
        catch (Throwable throwable) {
            throw this.getException(throwable);
        }
    }

    public Observable executeAsyncAsObservable() {
        return Observable.fromCallable(() -> {
            Entry entry = SphU.entry((String)this.getResourceName(this.handler, this.request));
            try {
                ResponseType ResponseType = this.handler.execute(this.context, this.request);
                return ResponseType;
            }
            catch (Throwable throwable) {
                throw this.getException(throwable);
            }
            finally {
                entry.exit();
            }
        });
    }

    private String getResourceName(RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler, RequestType request) {
        ServiceConfigurationType serviceConfig = handler.getServiceConfiguration();
        CommandHandlerConfigurationType apiConfig = handler.getApiConfiguration();
        if (apiConfig != null && ((CommandHandlerConfig)apiConfig).getSentinelRunTime() != null && ((CommandHandlerConfig)apiConfig).getSentinelRunTime().getFlowControlConfig() != null && StringUtils.isNotEmpty((CharSequence)((CommandHandlerConfig)apiConfig).getSentinelRunTime().getFlowControlConfig().getPoolName())) {
            return ((CommandHandlerConfig)apiConfig).getSentinelRunTime().getFlowControlConfig().getPoolName();
        }
        if (serviceConfig != null && ((RevolverServiceConfig)serviceConfig).getSentinelCommandConfig() != null && ((RevolverServiceConfig)serviceConfig).getSentinelCommandConfig().getFlowControlConfig() != null && StringUtils.isNotEmpty((CharSequence)((RevolverServiceConfig)serviceConfig).getSentinelCommandConfig().getFlowControlConfig().getPoolName())) {
            return ((RevolverServiceConfig)serviceConfig).getSentinelCommandConfig().getFlowControlConfig().getPoolName();
        }
        return ((RevolverRequest)request).getApi();
    }

    private RevolverExecutionException getException(Throwable throwable) {
        return new RevolverExecutionException(RevolverExecutionException.Type.SERVICE_ERROR, String.format("Error executing command %s", RevolverCommandHelper.getName(this.request)), RevolverExceptionHelper.getLeafThrowable(throwable));
    }
}

