/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.discovery.model;

import io.dropwizard.revolver.discovery.EndpointSpec;
import io.dropwizard.revolver.discovery.SpecVisitor;
import io.dropwizard.revolver.discovery.model.EndpointSpecType;
import org.hibernate.validator.constraints.NotBlank;

public class SimpleEndpointSpec
extends EndpointSpec {
    @NotBlank
    private String host;
    private int port;

    public SimpleEndpointSpec() {
        super(EndpointSpecType.simple);
    }

    @Override
    public void accept(SpecVisitor visitor) {
        visitor.visit(this);
    }

    public SimpleEndpointSpec(EndpointSpecType type, String host, int port) {
        super(type);
        this.host = host;
        this.port = port;
    }

    public static SimpleEndpointSpecBuilder builder() {
        return new SimpleEndpointSpecBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public static class SimpleEndpointSpecBuilder {
        private EndpointSpecType type;
        private String host;
        private int port;

        SimpleEndpointSpecBuilder() {
        }

        public SimpleEndpointSpecBuilder type(EndpointSpecType type) {
            this.type = type;
            return this;
        }

        public SimpleEndpointSpecBuilder host(String host) {
            this.host = host;
            return this;
        }

        public SimpleEndpointSpecBuilder port(int port) {
            this.port = port;
            return this;
        }

        public SimpleEndpointSpec build() {
            return new SimpleEndpointSpec(this.type, this.host, this.port);
        }

        public String toString() {
            return "SimpleEndpointSpec.SimpleEndpointSpecBuilder(type=" + (Object)((Object)this.type) + ", host=" + this.host + ", port=" + this.port + ")";
        }
    }
}

