/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer.config;

public class OptimizerConcurrencyConfig {
    private boolean enabled = true;
    private double maxThreshold = 0.85;
    private double minThreshold = 0.5;
    private double bandwidth = 1.4;
    private double maxThreadsMultiplier = 1.4;

    public static OptimizerConcurrencyConfigBuilder builder() {
        return new OptimizerConcurrencyConfigBuilder();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public double getMaxThreshold() {
        return this.maxThreshold;
    }

    public double getMinThreshold() {
        return this.minThreshold;
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public double getMaxThreadsMultiplier() {
        return this.maxThreadsMultiplier;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setMaxThreshold(double maxThreshold) {
        this.maxThreshold = maxThreshold;
    }

    public void setMinThreshold(double minThreshold) {
        this.minThreshold = minThreshold;
    }

    public void setBandwidth(double bandwidth) {
        this.bandwidth = bandwidth;
    }

    public void setMaxThreadsMultiplier(double maxThreadsMultiplier) {
        this.maxThreadsMultiplier = maxThreadsMultiplier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerConcurrencyConfig)) {
            return false;
        }
        OptimizerConcurrencyConfig other = (OptimizerConcurrencyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (Double.compare(this.getMaxThreshold(), other.getMaxThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinThreshold(), other.getMinThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getBandwidth(), other.getBandwidth()) != 0) {
            return false;
        }
        return Double.compare(this.getMaxThreadsMultiplier(), other.getMaxThreadsMultiplier()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerConcurrencyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $maxThreshold = Double.doubleToLongBits(this.getMaxThreshold());
        result = result * 59 + (int)($maxThreshold >>> 32 ^ $maxThreshold);
        long $minThreshold = Double.doubleToLongBits(this.getMinThreshold());
        result = result * 59 + (int)($minThreshold >>> 32 ^ $minThreshold);
        long $bandwidth = Double.doubleToLongBits(this.getBandwidth());
        result = result * 59 + (int)($bandwidth >>> 32 ^ $bandwidth);
        long $maxThreadsMultiplier = Double.doubleToLongBits(this.getMaxThreadsMultiplier());
        result = result * 59 + (int)($maxThreadsMultiplier >>> 32 ^ $maxThreadsMultiplier);
        return result;
    }

    public String toString() {
        return "OptimizerConcurrencyConfig(enabled=" + this.isEnabled() + ", maxThreshold=" + this.getMaxThreshold() + ", minThreshold=" + this.getMinThreshold() + ", bandwidth=" + this.getBandwidth() + ", maxThreadsMultiplier=" + this.getMaxThreadsMultiplier() + ")";
    }

    public OptimizerConcurrencyConfig(boolean enabled, double maxThreshold, double minThreshold, double bandwidth, double maxThreadsMultiplier) {
        this.enabled = enabled;
        this.maxThreshold = maxThreshold;
        this.minThreshold = minThreshold;
        this.bandwidth = bandwidth;
        this.maxThreadsMultiplier = maxThreadsMultiplier;
    }

    public OptimizerConcurrencyConfig() {
    }

    public static class OptimizerConcurrencyConfigBuilder {
        private boolean enabled;
        private double maxThreshold;
        private double minThreshold;
        private double bandwidth;
        private double maxThreadsMultiplier;

        OptimizerConcurrencyConfigBuilder() {
        }

        public OptimizerConcurrencyConfigBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public OptimizerConcurrencyConfigBuilder maxThreshold(double maxThreshold) {
            this.maxThreshold = maxThreshold;
            return this;
        }

        public OptimizerConcurrencyConfigBuilder minThreshold(double minThreshold) {
            this.minThreshold = minThreshold;
            return this;
        }

        public OptimizerConcurrencyConfigBuilder bandwidth(double bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public OptimizerConcurrencyConfigBuilder maxThreadsMultiplier(double maxThreadsMultiplier) {
            this.maxThreadsMultiplier = maxThreadsMultiplier;
            return this;
        }

        public OptimizerConcurrencyConfig build() {
            return new OptimizerConcurrencyConfig(this.enabled, this.maxThreshold, this.minThreshold, this.bandwidth, this.maxThreadsMultiplier);
        }

        public String toString() {
            return "OptimizerConcurrencyConfig.OptimizerConcurrencyConfigBuilder(enabled=" + this.enabled + ", maxThreshold=" + this.maxThreshold + ", minThreshold=" + this.minThreshold + ", bandwidth=" + this.bandwidth + ", maxThreadsMultiplier=" + this.maxThreadsMultiplier + ")";
        }
    }
}

