/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import io.dropwizard.revolver.optimizer.OptimizerCacheKey;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import io.dropwizard.revolver.optimizer.OptimizerMetricsCache;
import io.dropwizard.revolver.optimizer.config.OptimizerConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerTimeConfig;
import io.dropwizard.revolver.optimizer.utils.OptimizerUtils;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerMetricsCollector
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(OptimizerMetricsCollector.class);
    private MetricRegistry metrics;
    private OptimizerMetricsCache optimizerMetricsCache;
    private OptimizerConfig optimizerConfig;

    @Override
    public void run() {
        log.info("Running optimiser metrics collection job");
        SortedMap gauges = this.metrics.getGauges();
        Long time = System.currentTimeMillis();
        try {
            this.captureThreadPoolMetrics(gauges, time);
            this.captureTimeMetrics(gauges, time);
        }
        catch (Exception e) {
            log.error("Error occurred while executing metrics collector");
        }
    }

    private void captureThreadPoolMetrics(SortedMap<String, Gauge> gauges, Long time) {
        gauges.forEach((k, v) -> {
            OptimizerMetrics optimizerMetrics;
            String[] splits = k.split("\\.");
            if (splits.length < 3) {
                return;
            }
            int length = splits.length;
            String metricName = splits[length - 1];
            if (!OptimizerUtils.getMetricsToRead().contains(metricName) || !(v.getValue() instanceof Number)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            String delimiter = "";
            for (int i = 1; i < length - 1; ++i) {
                sb.append(delimiter);
                sb.append(splits[i]);
                delimiter = ".";
            }
            OptimizerCacheKey key = new OptimizerCacheKey(time, sb.toString());
            if (this.optimizerMetricsCache.get(key) == null) {
                this.optimizerMetricsCache.put(key, OptimizerMetrics.builder().metrics(Maps.newHashMap()).aggregationAlgo(OptimizerMetrics.AggregationAlgo.MAX).build());
            }
            if ((optimizerMetrics = this.optimizerMetricsCache.get(key)) == null) {
                return;
            }
            optimizerMetrics.getMetrics().put(metricName, (Number)v.getValue());
        });
    }

    private void captureTimeMetrics(SortedMap<String, Gauge> gauges, Long time) {
        OptimizerTimeConfig timeConfig = this.optimizerConfig.getTimeConfig();
        gauges.forEach((k, v) -> {
            OptimizerMetrics optimizerMetrics;
            if (timeConfig == null || !timeConfig.isEnabled()) {
                return;
            }
            String[] splits = k.split("\\.");
            if (splits.length < 4) {
                return;
            }
            int length = splits.length;
            String metricName = splits[length - 1];
            if (!timeConfig.getLatencyMetrics().contains(metricName) || !(v.getValue() instanceof Number)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            String delimiter = "";
            for (int i = 1; i < length - 1; ++i) {
                sb.append(delimiter);
                sb.append(splits[i]);
                delimiter = ".";
            }
            OptimizerCacheKey key = new OptimizerCacheKey(time, sb.toString());
            if (this.optimizerMetricsCache.get(key) == null) {
                this.optimizerMetricsCache.put(key, OptimizerMetrics.builder().metrics(Maps.newHashMap()).aggregationAlgo(OptimizerMetrics.AggregationAlgo.AVG).build());
            }
            if ((optimizerMetrics = this.optimizerMetricsCache.get(key)) == null) {
                return;
            }
            optimizerMetrics.getMetrics().put(metricName, (Number)v.getValue());
        });
    }

    public static OptimizerMetricsCollectorBuilder builder() {
        return new OptimizerMetricsCollectorBuilder();
    }

    public OptimizerMetricsCollector(MetricRegistry metrics, OptimizerMetricsCache optimizerMetricsCache, OptimizerConfig optimizerConfig) {
        this.metrics = metrics;
        this.optimizerMetricsCache = optimizerMetricsCache;
        this.optimizerConfig = optimizerConfig;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public OptimizerMetricsCache getOptimizerMetricsCache() {
        return this.optimizerMetricsCache;
    }

    public OptimizerConfig getOptimizerConfig() {
        return this.optimizerConfig;
    }

    public void setMetrics(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public void setOptimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public void setOptimizerConfig(OptimizerConfig optimizerConfig) {
        this.optimizerConfig = optimizerConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerMetricsCollector)) {
            return false;
        }
        OptimizerMetricsCollector other = (OptimizerMetricsCollector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricRegistry this$metrics = this.getMetrics();
        MetricRegistry other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
            return false;
        }
        OptimizerMetricsCache this$optimizerMetricsCache = this.getOptimizerMetricsCache();
        OptimizerMetricsCache other$optimizerMetricsCache = other.getOptimizerMetricsCache();
        if (this$optimizerMetricsCache == null ? other$optimizerMetricsCache != null : !((Object)this$optimizerMetricsCache).equals(other$optimizerMetricsCache)) {
            return false;
        }
        OptimizerConfig this$optimizerConfig = this.getOptimizerConfig();
        OptimizerConfig other$optimizerConfig = other.getOptimizerConfig();
        return !(this$optimizerConfig == null ? other$optimizerConfig != null : !((Object)this$optimizerConfig).equals(other$optimizerConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerMetricsCollector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetricRegistry $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        OptimizerMetricsCache $optimizerMetricsCache = this.getOptimizerMetricsCache();
        result = result * 59 + ($optimizerMetricsCache == null ? 43 : ((Object)$optimizerMetricsCache).hashCode());
        OptimizerConfig $optimizerConfig = this.getOptimizerConfig();
        result = result * 59 + ($optimizerConfig == null ? 43 : ((Object)$optimizerConfig).hashCode());
        return result;
    }

    public String toString() {
        return "OptimizerMetricsCollector(metrics=" + this.getMetrics() + ", optimizerMetricsCache=" + this.getOptimizerMetricsCache() + ", optimizerConfig=" + this.getOptimizerConfig() + ")";
    }

    public static class OptimizerMetricsCollectorBuilder {
        private MetricRegistry metrics;
        private OptimizerMetricsCache optimizerMetricsCache;
        private OptimizerConfig optimizerConfig;

        OptimizerMetricsCollectorBuilder() {
        }

        public OptimizerMetricsCollectorBuilder metrics(MetricRegistry metrics) {
            this.metrics = metrics;
            return this;
        }

        public OptimizerMetricsCollectorBuilder optimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
            this.optimizerMetricsCache = optimizerMetricsCache;
            return this;
        }

        public OptimizerMetricsCollectorBuilder optimizerConfig(OptimizerConfig optimizerConfig) {
            this.optimizerConfig = optimizerConfig;
            return this;
        }

        public OptimizerMetricsCollector build() {
            return new OptimizerMetricsCollector(this.metrics, this.optimizerMetricsCache, this.optimizerConfig);
        }

        public String toString() {
            return "OptimizerMetricsCollector.OptimizerMetricsCollectorBuilder(metrics=" + this.metrics + ", optimizerMetricsCache=" + this.optimizerMetricsCache + ", optimizerConfig=" + this.optimizerConfig + ")";
        }
    }
}

