/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.revolver.exception.RevolverException;
import io.dropwizard.revolver.util.ResponseTransformationUtil;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json", "application/msgpack", "application/xml"})
public class RevolverExceptionMapper
implements ExceptionMapper<RevolverException> {
    private ObjectMapper jsonObjectMapper;
    private ObjectMapper msgPackObjectMapper;
    @Context
    private HttpHeaders headers;

    public RevolverExceptionMapper(ObjectMapper objectMapper, ObjectMapper msgPackObjectMapper) {
        this.jsonObjectMapper = objectMapper;
        this.msgPackObjectMapper = msgPackObjectMapper;
    }

    public Response toResponse(RevolverException exception) {
        ImmutableMap response = ImmutableMap.builder().put((Object)"errorCode", (Object)exception.getErrorCode()).put((Object)"message", (Object)exception.getMessage()).build();
        try {
            if (this.headers.getAcceptableMediaTypes().size() == 0) {
                return Response.ok((Object)ResponseTransformationUtil.transform(response, "application/json", this.jsonObjectMapper, this.msgPackObjectMapper), (String)"application/json").build();
            }
            return Response.ok((Object)ResponseTransformationUtil.transform(response, ((MediaType)this.headers.getAcceptableMediaTypes().get(0)).toString(), this.jsonObjectMapper, this.msgPackObjectMapper), (String)((MediaType)this.headers.getAcceptableMediaTypes().get(0)).toString()).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)"Server Error".getBytes()).build();
        }
    }
}

