/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.resource;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Metered;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.dropwizard.jersey.PATCH;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.base.core.RevolverAckMessage;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.callback.InlineCallbackHandler;
import io.dropwizard.revolver.core.config.ApiLatencyConfig;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.tracing.TraceInfo;
import io.dropwizard.revolver.http.RevolverHttpCommand;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.model.ApiPathMap;
import io.dropwizard.revolver.http.model.RevolverHttpRequest;
import io.dropwizard.revolver.http.model.RevolverHttpResponse;
import io.dropwizard.revolver.optimizer.config.OptimizerTimeConfig;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import io.dropwizard.revolver.util.ResponseTransformationUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/apis")
@Singleton
@Api(value="Revolver Gateway", description="Revolver api gateway endpoints")
public class RevolverRequestResource {
    private static final Logger log = LoggerFactory.getLogger(RevolverRequestResource.class);
    private final ObjectMapper jsonObjectMapper;
    private final ObjectMapper msgPackObjectMapper;
    private final PersistenceProvider persistenceProvider;
    private final InlineCallbackHandler callbackHandler;
    private final MetricRegistry metrics;
    private final RevolverConfig revolverConfig;
    private static final Map<String, String> BAD_REQUEST_RESPONSE = Collections.singletonMap("message", "Bad Request");
    private static Map<String, String> SERVICE_UNAVAILABLE_RESPONSE = Collections.singletonMap("message", "Service Unavailable");
    private static final Map<String, String> DUPLICATE_REQUEST_RESPONSE = Collections.singletonMap("message", "Duplicate");

    public RevolverRequestResource(ObjectMapper jsonObjectMapper, ObjectMapper msgPackObjectMapper, PersistenceProvider persistenceProvider, InlineCallbackHandler callbackHandler, MetricRegistry metrics, RevolverConfig revolverConfig) {
        this.jsonObjectMapper = jsonObjectMapper;
        this.msgPackObjectMapper = msgPackObjectMapper;
        this.persistenceProvider = persistenceProvider;
        this.callbackHandler = callbackHandler;
        this.metrics = metrics;
        this.revolverConfig = revolverConfig;
    }

    @GET
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver GET api endpoint")
    public Response get(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        Response response = this.processRequest(service, RevolverHttpApiConfig.RequestMethod.GET, path, headers, uriInfo, null);
        this.pushMetrics(response, service, path);
        return response;
    }

    @HEAD
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver HEAD api endpoint")
    public Response head(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        Response response = this.processRequest(service, RevolverHttpApiConfig.RequestMethod.HEAD, path, headers, uriInfo, null);
        this.pushMetrics(response, service, path);
        return response;
    }

    @POST
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver POST api endpoint")
    public Response post(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws Exception {
        Response response = this.processRequest(service, RevolverHttpApiConfig.RequestMethod.POST, path, headers, uriInfo, body);
        this.pushMetrics(response, service, path);
        return response;
    }

    @PUT
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver PUT api endpoint")
    public Response put(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws Exception {
        Response response = this.processRequest(service, RevolverHttpApiConfig.RequestMethod.PUT, path, headers, uriInfo, body);
        this.pushMetrics(response, service, path);
        return response;
    }

    @DELETE
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver DELETE api endpoint")
    public Response delete(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        Response response = this.processRequest(service, RevolverHttpApiConfig.RequestMethod.DELETE, path, headers, uriInfo, null);
        this.pushMetrics(response, service, path);
        return response;
    }

    @PATCH
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver PATCH api endpoint")
    public Response patch(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws Exception {
        Response response = this.processRequest(service, RevolverHttpApiConfig.RequestMethod.PATCH, path, headers, uriInfo, body);
        this.pushMetrics(response, service, path);
        return response;
    }

    @OPTIONS
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver OPTIONS api endpoint")
    public Response options(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws Exception {
        Response response = this.processRequest(service, RevolverHttpApiConfig.RequestMethod.OPTIONS, path, headers, uriInfo, body);
        this.pushMetrics(response, service, path);
        return response;
    }

    private Response processRequest(String service, RevolverHttpApiConfig.RequestMethod method, String path, HttpHeaders headers, UriInfo uriInfo, byte[] body) throws Exception {
        ApiPathMap apiMap = RevolverBundle.matchPath(service, path);
        if (apiMap == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ResponseTransformationUtil.transform(BAD_REQUEST_RESPONSE, headers.getMediaType() != null ? headers.getMediaType().toString() : "application/json", this.jsonObjectMapper, this.msgPackObjectMapper)).build();
        }
        String serviceKey = service + "." + apiMap.getApi().getApi();
        if (RevolverBundle.apiStatus.containsKey(serviceKey) && !RevolverBundle.apiStatus.get(serviceKey).booleanValue()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)ResponseTransformationUtil.transform(SERVICE_UNAVAILABLE_RESPONSE, headers.getMediaType() != null ? headers.getMediaType().toString() : "application/json", this.jsonObjectMapper, this.msgPackObjectMapper)).build();
        }
        String callMode = this.getCallMode(apiMap, headers);
        if (Strings.isNullOrEmpty((String)callMode)) {
            return this.executeInline(service, apiMap.getApi(), method, path, headers, uriInfo, body);
        }
        switch (callMode.toUpperCase()) {
            case "POLLING": {
                return this.executeCommandAsync(service, apiMap.getApi(), method, path, headers, uriInfo, body, apiMap.getApi().isAsync(), callMode);
            }
            case "CALLBACK": {
                if (Strings.isNullOrEmpty((String)headers.getHeaderString("X-CALLBACK-URI"))) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ResponseTransformationUtil.transform(BAD_REQUEST_RESPONSE, headers.getMediaType() != null ? headers.getMediaType().toString() : "application/json", this.jsonObjectMapper, this.msgPackObjectMapper)).build();
                }
                return this.executeCommandAsync(service, apiMap.getApi(), method, path, headers, uriInfo, body, apiMap.getApi().isAsync(), callMode);
            }
            case "CALLBACK_SYNC": {
                if (Strings.isNullOrEmpty((String)headers.getHeaderString("X-CALLBACK-URI"))) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ResponseTransformationUtil.transform(BAD_REQUEST_RESPONSE, headers.getMediaType() != null ? headers.getMediaType().toString() : "application/json", this.jsonObjectMapper, this.msgPackObjectMapper)).build();
                }
                return this.executeCallbackSync(service, apiMap.getApi(), method, path, headers, uriInfo, body);
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ResponseTransformationUtil.transform(BAD_REQUEST_RESPONSE, headers.getMediaType() != null ? headers.getMediaType().toString() : "application/json", this.jsonObjectMapper, this.msgPackObjectMapper)).build();
    }

    private String getCallMode(ApiPathMap apiMap, HttpHeaders headers) {
        String callMode = (String)headers.getRequestHeaders().getFirst((Object)"X-CALL-MODE");
        if (this.revolverConfig.getOptimizerConfig() == null || !this.revolverConfig.getOptimizerConfig().isEnabled() || this.revolverConfig.getOptimizerConfig().getTimeConfig() == null || !Strings.isNullOrEmpty((String)callMode)) {
            return callMode;
        }
        ApiLatencyConfig apiLatencyConfig = apiMap.getApi().getApiLatencyConfig();
        if (apiLatencyConfig == null) {
            return callMode;
        }
        OptimizerTimeConfig timeoutConfig = this.revolverConfig.getOptimizerConfig().getTimeConfig();
        if (apiLatencyConfig.getLatency() > (double)timeoutConfig.getAppLatencyThresholdValue()) {
            log.error("callMode updated for api : " + apiMap.getApi().getApi() + ", apiLatency : " + apiLatencyConfig.getLatency() + " ,appLatency :" + timeoutConfig.getAppLatencyThresholdValue());
            return callMode;
        }
        return callMode;
    }

    private Response executeInline(String service, RevolverHttpApiConfig api, RevolverHttpApiConfig.RequestMethod method, String path, HttpHeaders headers, UriInfo uriInfo, byte[] body) throws IOException, TimeoutException {
        MultivaluedHashMap sanatizedHeaders = new MultivaluedHashMap();
        headers.getRequestHeaders().forEach((arg_0, arg_1) -> ((MultivaluedHashMap)sanatizedHeaders).put(arg_0, arg_1));
        this.cleanHeaders((MultivaluedMap<String, String>)sanatizedHeaders, api);
        RevolverHttpCommand httpCommand = RevolverBundle.getHttpCommand(service, api.getApi());
        RevolverHttpResponse revolverHttpResponse = this.execute(httpCommand, service, api, method, path, headers, uriInfo, body, (MultivaluedHashMap<String, String>)sanatizedHeaders);
        return this.transform(headers, revolverHttpResponse, api.getApi(), path, method);
    }

    private RevolverHttpResponse execute(RevolverHttpCommand httpCommand, String service, RevolverHttpApiConfig api, RevolverHttpApiConfig.RequestMethod method, String path, HttpHeaders headers, UriInfo uriInfo, byte[] body, MultivaluedHashMap<String, String> sanatizedHeaders) throws TimeoutException {
        return (RevolverHttpResponse)httpCommand.execute(RevolverHttpRequest.builder().traceInfo(TraceInfo.builder().requestId(headers.getHeaderString("X-REQUEST-ID")).transactionId(headers.getHeaderString("X-TRANSACTION-ID")).timestamp(System.currentTimeMillis()).build()).api(api.getApi()).service(service).path(path).method(method).headers((MultivaluedMap<String, String>)sanatizedHeaders).queryParams((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).body(body).build());
    }

    private Response transform(HttpHeaders headers, RevolverHttpResponse response, String api, String path, RevolverHttpApiConfig.RequestMethod method) throws IOException {
        String requestMediaType;
        Response.ResponseBuilder httpResponse = Response.status((int)response.getStatusCode());
        if (response.getHeaders() != null) {
            response.getHeaders().keySet().stream().filter(h -> !h.equalsIgnoreCase("Content-Type")).filter(h -> !h.equalsIgnoreCase("Content-Length")).forEach(h -> httpResponse.header(h, response.getHeaders().getFirst(h)));
        }
        httpResponse.header("X-REQUESTED-PATH", (Object)path);
        httpResponse.header("X-REQUESTED-METHOD", (Object)method);
        httpResponse.header("X-REQUESTED-API", (Object)api);
        String responseMediaType = response.getHeaders() != null && Strings.isNullOrEmpty((String)((String)response.getHeaders().getFirst((Object)"Content-Type"))) ? "text/html" : (String)response.getHeaders().getFirst((Object)"Content-Type");
        String string = requestMediaType = headers != null && Strings.isNullOrEmpty((String)headers.getHeaderString("Accept")) ? null : headers.getHeaderString("Accept");
        if (Strings.isNullOrEmpty((String)requestMediaType) || requestMediaType.equals(responseMediaType)) {
            httpResponse.header("Content-Type", (Object)responseMediaType);
            httpResponse.entity((Object)response.getBody());
            return httpResponse.build();
        }
        Object responseData = null;
        if (responseMediaType.startsWith("application/json")) {
            JsonNode jsonNode = this.jsonObjectMapper.readTree(response.getBody());
            responseData = jsonNode.isArray() ? this.jsonObjectMapper.convertValue((Object)jsonNode, List.class) : this.jsonObjectMapper.convertValue((Object)jsonNode, Map.class);
        } else if (responseMediaType.startsWith("application/msgpack")) {
            JsonNode jsonNode = this.msgPackObjectMapper.readTree(response.getBody());
            responseData = jsonNode.isArray() ? this.msgPackObjectMapper.convertValue((Object)jsonNode, List.class) : this.msgPackObjectMapper.convertValue((Object)jsonNode, Map.class);
        }
        if (responseData == null) {
            httpResponse.entity((Object)response.getBody());
        } else if (requestMediaType.startsWith("application/json")) {
            httpResponse.header("Content-Type", (Object)"application/json");
            httpResponse.entity((Object)this.jsonObjectMapper.writeValueAsBytes(responseData));
        } else if (requestMediaType.startsWith("application/msgpack")) {
            httpResponse.header("Content-Type", (Object)"application/msgpack");
            httpResponse.entity((Object)this.msgPackObjectMapper.writeValueAsBytes(responseData));
        } else {
            httpResponse.header("Content-Type", (Object)"application/json");
            httpResponse.entity((Object)this.jsonObjectMapper.writeValueAsBytes(responseData));
        }
        return httpResponse.build();
    }

    private void cleanHeaders(MultivaluedMap<String, String> headers, RevolverHttpApiConfig apiConfig) {
        headers.remove((Object)"Host");
        headers.remove((Object)"Accept");
        headers.remove((Object)"Accept-Encoding");
        headers.putSingle((Object)"Accept", (Object)apiConfig.getAcceptType());
        headers.putSingle((Object)"Accept-Encoding", (Object)apiConfig.getAcceptEncoding());
    }

    private Response executeCommandAsync(String service, RevolverHttpApiConfig api, RevolverHttpApiConfig.RequestMethod method, String path, HttpHeaders headers, UriInfo uriInfo, byte[] body, boolean isDownstreamAsync, String callMode) throws Exception {
        int mailBoxTtl;
        MultivaluedHashMap sanatizedHeaders = new MultivaluedHashMap();
        headers.getRequestHeaders().forEach((arg_0, arg_1) -> ((MultivaluedHashMap)sanatizedHeaders).put(arg_0, arg_1));
        this.cleanHeaders((MultivaluedMap<String, String>)sanatizedHeaders, api);
        RevolverHttpCommand httpCommand = RevolverBundle.getHttpCommand(service, api.getApi());
        String requestId = headers.getHeaderString("X-REQUEST-ID");
        String transactionId = headers.getHeaderString("X-TRANSACTION-ID");
        String mailBoxId = headers.getHeaderString("X-MAILBOX-ID");
        int n = mailBoxTtl = headers.getHeaderString("X-MAILBOX-TTL") != null ? Integer.parseInt(headers.getHeaderString("X-MAILBOX-TTL")) : -1;
        if (this.persistenceProvider.exists(requestId)) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)ResponseTransformationUtil.transform(DUPLICATE_REQUEST_RESPONSE, headers.getMediaType() == null ? "application/json" : headers.getMediaType().toString(), this.jsonObjectMapper, this.msgPackObjectMapper)).build();
        }
        this.persistenceProvider.saveRequest(requestId, mailBoxId, RevolverCallbackRequest.builder().api(api.getApi()).mode((String)headers.getRequestHeaders().getFirst((Object)"X-CALL-MODE")).callbackUri((String)headers.getRequestHeaders().getFirst((Object)"X-CALLBACK-URI")).method((String)headers.getRequestHeaders().getFirst((Object)"X-CALLBACK-METHOD")).service(service).path(path).headers((Map<String, List<String>>)headers.getRequestHeaders()).queryParams((Map<String, List<String>>)uriInfo.getQueryParameters()).body(body).build(), mailBoxTtl);
        CompletableFuture response = httpCommand.executeAsync(RevolverHttpRequest.builder().traceInfo(TraceInfo.builder().requestId(requestId).transactionId(transactionId).timestamp(System.currentTimeMillis()).build()).api(api.getApi()).service(service).path(path).method(method).headers((MultivaluedMap<String, String>)sanatizedHeaders).queryParams((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).body(body).build());
        if (isDownstreamAsync) {
            RevolverHttpResponse result2 = (RevolverHttpResponse)response.get();
            if (result2.getStatusCode() == Response.Status.ACCEPTED.getStatusCode()) {
                this.persistenceProvider.setRequestState(requestId, RevolverRequestState.REQUESTED, mailBoxTtl);
            } else {
                this.persistenceProvider.setRequestState(requestId, RevolverRequestState.RESPONDED, mailBoxTtl);
                this.saveResponse(requestId, result2, callMode, mailBoxTtl);
            }
            Response httpResponse = this.transform(headers, result2, api.getApi(), path, method);
            if (api.getApiLatencyConfig() != null) {
                log.error("retryAfter : " + api.getApiLatencyConfig().getLatency() + ", api : " + api + ", isDownstreamAsync" + isDownstreamAsync);
                httpResponse.getHeaders().putSingle((Object)"X-RETRY-AFTER", (Object)api.getApiLatencyConfig().getLatency());
            }
            return httpResponse;
        }
        response.thenAcceptAsync(result -> {
            try {
                if (result.getStatusCode() == Response.Status.ACCEPTED.getStatusCode()) {
                    this.persistenceProvider.setRequestState(requestId, RevolverRequestState.REQUESTED, mailBoxTtl);
                } else if (result.getStatusCode() == Response.Status.OK.getStatusCode()) {
                    this.persistenceProvider.setRequestState(requestId, RevolverRequestState.RESPONDED, mailBoxTtl);
                    this.saveResponse(requestId, (RevolverHttpResponse)result, callMode, mailBoxTtl);
                } else {
                    this.persistenceProvider.setRequestState(requestId, RevolverRequestState.ERROR, mailBoxTtl);
                    this.saveResponse(requestId, (RevolverHttpResponse)result, callMode, mailBoxTtl);
                }
            }
            catch (Exception e) {
                log.error("Error setting request state for request id: {}", (Object)requestId, (Object)e);
            }
        });
        if (api.getApiLatencyConfig() != null) {
            log.error("retryAfter : " + api.getApiLatencyConfig().getLatency() + ", api : " + api + ", isDownstreamAsync" + isDownstreamAsync);
        }
        RevolverAckMessage revolverAckMessage = RevolverAckMessage.builder().requestId(requestId).acceptedAt(Instant.now().toEpochMilli()).build();
        return Response.accepted().entity((Object)ResponseTransformationUtil.transform(revolverAckMessage, headers.getMediaType() == null ? "application/json" : headers.getMediaType().toString(), this.jsonObjectMapper, this.msgPackObjectMapper)).header("X-RETRY-AFTER", (Object)(api.getApiLatencyConfig() == null ? 0.0 : api.getApiLatencyConfig().getLatency())).build();
    }

    private Response executeCallbackSync(String service, RevolverHttpApiConfig api, RevolverHttpApiConfig.RequestMethod method, String path, HttpHeaders headers, UriInfo uriInfo, byte[] body) throws Exception {
        int mailBoxTtl;
        MultivaluedHashMap sanatizedHeaders = new MultivaluedHashMap();
        headers.getRequestHeaders().forEach((arg_0, arg_1) -> ((MultivaluedHashMap)sanatizedHeaders).put(arg_0, arg_1));
        this.cleanHeaders((MultivaluedMap<String, String>)sanatizedHeaders, api);
        RevolverHttpCommand httpCommand = RevolverBundle.getHttpCommand(service, api.getApi());
        String requestId = headers.getHeaderString("X-REQUEST-ID");
        String transactionId = headers.getHeaderString("X-TRANSACTION-ID");
        String mailBoxId = headers.getHeaderString("X-MAILBOX-ID");
        int n = mailBoxTtl = headers.getHeaderString("X-MAILBOX-TTL") != null ? Integer.parseInt(headers.getHeaderString("X-MAILBOX-TTL")) : -1;
        if (this.persistenceProvider.exists(requestId)) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)ResponseTransformationUtil.transform(DUPLICATE_REQUEST_RESPONSE, headers.getMediaType() == null ? "application/json" : headers.getMediaType().toString(), this.jsonObjectMapper, this.msgPackObjectMapper)).build();
        }
        this.persistenceProvider.saveRequest(requestId, mailBoxId, RevolverCallbackRequest.builder().api(api.getApi()).mode((String)headers.getRequestHeaders().getFirst((Object)"X-CALL-MODE")).callbackUri((String)headers.getRequestHeaders().getFirst((Object)"X-CALLBACK-URI")).method((String)headers.getRequestHeaders().getFirst((Object)"X-CALLBACK-METHOD")).service(service).path(path).headers((Map<String, List<String>>)headers.getRequestHeaders()).queryParams((Map<String, List<String>>)uriInfo.getQueryParameters()).body(body).build(), mailBoxTtl);
        CompletableFuture response = httpCommand.executeAsync(RevolverHttpRequest.builder().traceInfo(TraceInfo.builder().requestId(requestId).transactionId(transactionId).timestamp(System.currentTimeMillis()).build()).api(api.getApi()).service(service).path(path).method(method).headers((MultivaluedMap<String, String>)sanatizedHeaders).queryParams((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).body(body).build());
        this.persistenceProvider.setRequestState(requestId, RevolverRequestState.REQUESTED, mailBoxTtl);
        RevolverHttpResponse result = (RevolverHttpResponse)response.get();
        return this.transform(headers, result, api.getApi(), path, method);
    }

    private void saveResponse(String requestId, RevolverHttpResponse result, String callMode, int ttl) {
        try {
            RevolverCallbackResponse response = RevolverCallbackResponse.builder().body(result.getBody()).headers((Map<String, List<String>>)result.getHeaders()).statusCode(result.getStatusCode()).build();
            this.persistenceProvider.saveResponse(requestId, response, ttl);
            if (callMode != null && callMode.equals("CALLBACK")) {
                this.callbackHandler.handle(requestId, response);
            }
        }
        catch (Exception e) {
            log.error("Error saving response!", (Throwable)e);
        }
    }

    private void pushMetrics(Response response, String service, String path) {
        ApiPathMap apiMap = RevolverBundle.matchPath(service, path);
        if (apiMap == null) {
            return;
        }
        String api = apiMap.getApi().getApi();
        this.metrics.meter(String.format("%s.%s.%s", service, api, response.getStatus()));
    }
}

