/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import io.dropwizard.revolver.optimizer.OptimizerMetricsCache;
import io.dropwizard.revolver.optimizer.config.OptimizerConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerTimeoutConfig;
import io.dropwizard.revolver.optimizer.utils.OptimizerUtils;
import java.util.SortedMap;
import org.msgpack.jackson.dataformat.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerMetricsBuilder
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(OptimizerMetricsBuilder.class);
    private MetricRegistry metrics;
    private OptimizerMetricsCache optimizerMetricsCache;
    private OptimizerConfig optimizerConfig;

    @Override
    public void run() {
        SortedMap gauges = this.metrics.getGauges();
        Long time = System.currentTimeMillis();
        this.captureThreadPoolMetrics(gauges, time);
        this.captureRunTimeMetrics(gauges, time);
    }

    private void captureThreadPoolMetrics(SortedMap<String, Gauge> gauges, Long time) {
        gauges.forEach((k, v) -> {
            OptimizerMetrics optimizerMetrics;
            String[] splits = k.split("\\.");
            if (splits.length < 3) {
                return;
            }
            int length = splits.length;
            String metricName = splits[length - 1];
            if (!OptimizerUtils.getMetricsToRead().contains(metricName) || !(v.getValue() instanceof Number)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            String delimiter = "";
            for (int i = 1; i < length - 1; ++i) {
                sb.append(delimiter);
                sb.append(splits[i]);
                delimiter = ".";
            }
            Tuple key = new Tuple((Object)time, (Object)sb.toString());
            if (this.optimizerMetricsCache.get((Tuple<Long, String>)key) == null) {
                this.optimizerMetricsCache.put((Tuple<Long, String>)key, OptimizerMetrics.builder().metrics(Maps.newHashMap()).build());
            }
            if ((optimizerMetrics = this.optimizerMetricsCache.get((Tuple<Long, String>)key)) == null) {
                return;
            }
            optimizerMetrics.getMetrics().put(metricName, (Number)v.getValue());
        });
    }

    private void captureRunTimeMetrics(SortedMap<String, Gauge> gauges, Long time) {
        OptimizerTimeoutConfig timeoutConfig = this.optimizerConfig.getTimeoutConfig();
        gauges.forEach((k, v) -> {
            OptimizerMetrics optimizerMetrics;
            String[] splits = k.split("\\.");
            if (splits.length < 4) {
                return;
            }
            int length = splits.length;
            String metricName = splits[length - 1];
            if (timeoutConfig.getTimeoutMetric().equals(metricName) && v.getValue() instanceof Number) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            String delimiter = "";
            for (int i = 1; i < length - 1; ++i) {
                sb.append(delimiter);
                sb.append(splits[i]);
                delimiter = ".";
            }
            Tuple key = new Tuple((Object)time, (Object)sb.toString());
            if (this.optimizerMetricsCache.get((Tuple<Long, String>)key) == null) {
                this.optimizerMetricsCache.put((Tuple<Long, String>)key, OptimizerMetrics.builder().metrics(Maps.newHashMap()).build());
            }
            if ((optimizerMetrics = this.optimizerMetricsCache.get((Tuple<Long, String>)key)) == null) {
                return;
            }
            log.error("Inputting value for metric : " + metricName + ", for key : " + (String)key.second() + ", with value : " + v.getValue());
            optimizerMetrics.getMetrics().put(metricName, (Number)v.getValue());
        });
    }

    public static OptimizerMetricsBuilderBuilder builder() {
        return new OptimizerMetricsBuilderBuilder();
    }

    public OptimizerMetricsBuilder(MetricRegistry metrics, OptimizerMetricsCache optimizerMetricsCache, OptimizerConfig optimizerConfig) {
        this.metrics = metrics;
        this.optimizerMetricsCache = optimizerMetricsCache;
        this.optimizerConfig = optimizerConfig;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public OptimizerMetricsCache getOptimizerMetricsCache() {
        return this.optimizerMetricsCache;
    }

    public OptimizerConfig getOptimizerConfig() {
        return this.optimizerConfig;
    }

    public void setMetrics(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public void setOptimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public void setOptimizerConfig(OptimizerConfig optimizerConfig) {
        this.optimizerConfig = optimizerConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerMetricsBuilder)) {
            return false;
        }
        OptimizerMetricsBuilder other = (OptimizerMetricsBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricRegistry this$metrics = this.getMetrics();
        MetricRegistry other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
            return false;
        }
        OptimizerMetricsCache this$optimizerMetricsCache = this.getOptimizerMetricsCache();
        OptimizerMetricsCache other$optimizerMetricsCache = other.getOptimizerMetricsCache();
        if (this$optimizerMetricsCache == null ? other$optimizerMetricsCache != null : !((Object)this$optimizerMetricsCache).equals(other$optimizerMetricsCache)) {
            return false;
        }
        OptimizerConfig this$optimizerConfig = this.getOptimizerConfig();
        OptimizerConfig other$optimizerConfig = other.getOptimizerConfig();
        return !(this$optimizerConfig == null ? other$optimizerConfig != null : !((Object)this$optimizerConfig).equals(other$optimizerConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerMetricsBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetricRegistry $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        OptimizerMetricsCache $optimizerMetricsCache = this.getOptimizerMetricsCache();
        result = result * 59 + ($optimizerMetricsCache == null ? 43 : ((Object)$optimizerMetricsCache).hashCode());
        OptimizerConfig $optimizerConfig = this.getOptimizerConfig();
        result = result * 59 + ($optimizerConfig == null ? 43 : ((Object)$optimizerConfig).hashCode());
        return result;
    }

    public String toString() {
        return "OptimizerMetricsBuilder(metrics=" + this.getMetrics() + ", optimizerMetricsCache=" + this.getOptimizerMetricsCache() + ", optimizerConfig=" + this.getOptimizerConfig() + ")";
    }

    public static class OptimizerMetricsBuilderBuilder {
        private MetricRegistry metrics;
        private OptimizerMetricsCache optimizerMetricsCache;
        private OptimizerConfig optimizerConfig;

        OptimizerMetricsBuilderBuilder() {
        }

        public OptimizerMetricsBuilderBuilder metrics(MetricRegistry metrics) {
            this.metrics = metrics;
            return this;
        }

        public OptimizerMetricsBuilderBuilder optimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
            this.optimizerMetricsCache = optimizerMetricsCache;
            return this;
        }

        public OptimizerMetricsBuilderBuilder optimizerConfig(OptimizerConfig optimizerConfig) {
            this.optimizerConfig = optimizerConfig;
            return this;
        }

        public OptimizerMetricsBuilder build() {
            return new OptimizerMetricsBuilder(this.metrics, this.optimizerMetricsCache, this.optimizerConfig);
        }

        public String toString() {
            return "OptimizerMetricsBuilder.OptimizerMetricsBuilderBuilder(metrics=" + this.metrics + ", optimizerMetricsCache=" + this.optimizerMetricsCache + ", optimizerConfig=" + this.optimizerConfig + ")";
        }
    }
}

