/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.google.common.collect.Maps;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.config.LatencyConfig;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.optimizer.OptimizerAggregatedMetrics;
import io.dropwizard.revolver.optimizer.OptimizerCacheKey;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import io.dropwizard.revolver.optimizer.OptimizerMetricsCache;
import io.dropwizard.revolver.optimizer.config.OptimizerConcurrencyConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerTimeoutConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverConfigUpdater
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RevolverConfigUpdater.class);
    private RevolverConfig revolverConfig;
    private OptimizerConfig optimizerConfig;
    private OptimizerMetricsCache optimizerMetricsCache;

    @Override
    public void run() {
        HashMap optimizerAggregatedMetricsMap = Maps.newHashMap();
        Map<OptimizerCacheKey, OptimizerMetrics> metricsCache = this.optimizerMetricsCache.getCache();
        if (metricsCache.isEmpty()) {
            return;
        }
        metricsCache.forEach((key, optimizerMetrics) -> {
            if (optimizerAggregatedMetricsMap.get(key.getName()) == null) {
                optimizerAggregatedMetricsMap.put(key.getName(), OptimizerAggregatedMetrics.builder().pool(key.getName()).metricsAggValueMap(Maps.newHashMap()).build());
            }
            OptimizerAggregatedMetrics optimizerAggregatedMetrics = (OptimizerAggregatedMetrics)optimizerAggregatedMetricsMap.get(key.getName());
            Map<String, Number> aggregatedMetricsValues = optimizerAggregatedMetrics.getMetricsAggValueMap();
            optimizerMetrics.getMetrics().forEach((metric, value) -> {
                OptimizerMetrics.AggregationAlgo aggregationAlgo = optimizerMetrics.getAggregationAlgo();
                switch (aggregationAlgo) {
                    case MAX: {
                        if (aggregatedMetricsValues.get(metric) != null && ((Number)aggregatedMetricsValues.get(metric)).intValue() >= value.intValue()) break;
                        log.error("Max Algo : from " + aggregatedMetricsValues.get(metric) + ", to : " + value);
                        aggregatedMetricsValues.put((String)metric, (Number)value);
                        break;
                    }
                    case AVG: {
                        if (aggregatedMetricsValues.get(metric) == null) {
                            aggregatedMetricsValues.put((String)metric, (Number)value);
                            log.error("Avg Algo  to : " + value);
                            break;
                        }
                        log.error("Avg Algo : from " + aggregatedMetricsValues.get(metric) + ", to : " + (((Number)aggregatedMetricsValues.get(metric)).intValue() + value.intValue() >> 1));
                        aggregatedMetricsValues.put((String)metric, ((Number)aggregatedMetricsValues.get(metric)).intValue() + value.intValue() >> 1);
                    }
                }
            });
        });
        this.updateRevolverConfig(optimizerAggregatedMetricsMap);
    }

    private void updateRevolverConfig(Map<String, OptimizerAggregatedMetrics> optimizerAggregatedMetricsMap) {
        AtomicBoolean configUpdated = new AtomicBoolean();
        this.revolverConfig.getServices().forEach(revolverServiceConfig -> {
            if (revolverServiceConfig.getThreadPoolGroupConfig() != null) {
                revolverServiceConfig.getThreadPoolGroupConfig().getThreadPools().forEach(threadPoolConfig -> this.updatedPoolSettings((ThreadPoolConfig)threadPoolConfig, optimizerAggregatedMetricsMap, configUpdated));
            }
            if (revolverServiceConfig instanceof RevolverHttpServiceConfig) {
                ((RevolverHttpServiceConfig)revolverServiceConfig).getApis().forEach(api -> this.updatedApiSettings((RevolverServiceConfig)revolverServiceConfig, (RevolverHttpApiConfig)api, optimizerAggregatedMetricsMap, configUpdated));
            }
        });
        if (configUpdated.get()) {
            RevolverBundle.loadServiceConfiguration(this.revolverConfig);
        }
    }

    private void updatedPoolSettings(ThreadPoolConfig threadPoolConfig, Map<String, OptimizerAggregatedMetrics> optimizerAggregatedMetricsMap, AtomicBoolean configUpdated) {
        OptimizerAggregatedMetrics optimizerAggregatedMetrics = optimizerAggregatedMetricsMap.get(threadPoolConfig.getThreadPoolName());
        if (optimizerAggregatedMetrics == null) {
            return;
        }
        this.updateConcurrencySetting(threadPoolConfig, optimizerAggregatedMetrics, configUpdated, threadPoolConfig.getThreadPoolName());
    }

    private void updatedApiSettings(RevolverServiceConfig revolverServiceConfig, RevolverHttpApiConfig api, Map<String, OptimizerAggregatedMetrics> optimizerAggregatedMetricsMap, AtomicBoolean configUpdated) {
        String key = revolverServiceConfig.getService() + "." + api.getApi();
        OptimizerAggregatedMetrics optimizerAggregatedMetrics = optimizerAggregatedMetricsMap.get(key);
        if (optimizerAggregatedMetrics == null) {
            return;
        }
        this.updateConcurrencySetting(api.getRuntime().getThreadPool(), optimizerAggregatedMetrics, configUpdated, api.getApi());
        this.updateTimeoutSettings(api.getRuntime().getThreadPool(), optimizerAggregatedMetrics, configUpdated, api);
        this.updateLatencySettings(api, optimizerAggregatedMetrics);
    }

    private void updateConcurrencySetting(ThreadPoolConfig threadPoolConfig, OptimizerAggregatedMetrics optimizerAggregatedMetrics, AtomicBoolean configUpdated, String poolName) {
        if (optimizerAggregatedMetrics.getMetricsAggValueMap().get("rollingMaxActiveThreads") == null) {
            return;
        }
        OptimizerConcurrencyConfig concurrencyConfig = this.optimizerConfig.getConcurrencyConfig();
        int maxRollingActiveThreads = optimizerAggregatedMetrics.getMetricsAggValueMap().get("rollingMaxActiveThreads").intValue();
        int concurrency = threadPoolConfig.getConcurrency();
        if (maxRollingActiveThreads <= 3 && concurrency - 1 <= maxRollingActiveThreads) {
            return;
        }
        if (maxRollingActiveThreads == 0) {
            threadPoolConfig.setConcurrency(1);
            log.error("Setting concurrency for : " + poolName + " from : " + concurrency + " to : " + threadPoolConfig.getConcurrency() + ", maxRollingActiveThreads : " + maxRollingActiveThreads);
            return;
        }
        if ((double)maxRollingActiveThreads > (double)concurrency * concurrencyConfig.getMaxThreshold() || (double)maxRollingActiveThreads < (double)concurrency * concurrencyConfig.getMinThreshold()) {
            int updatedConcurrency = (int)Math.ceil((double)maxRollingActiveThreads * concurrencyConfig.getBandwidth());
            threadPoolConfig.setConcurrency(updatedConcurrency);
            configUpdated.set(true);
            log.error("Setting concurrency for : " + poolName + " from : " + concurrency + " to : " + updatedConcurrency + ", maxRollingActiveThreads : " + maxRollingActiveThreads);
        }
    }

    private void updateTimeoutSettings(ThreadPoolConfig threadPool, OptimizerAggregatedMetrics optimizerAggregatedMetrics, AtomicBoolean configUpdated, RevolverHttpApiConfig api) {
        int currentTimeout;
        OptimizerTimeoutConfig timeoutConfig = this.optimizerConfig.getTimeoutConfig();
        if (timeoutConfig == null || optimizerAggregatedMetrics.getMetricsAggValueMap().get(timeoutConfig.getTimeoutMetric()) == null) {
            return;
        }
        int meanTimeoutValue = optimizerAggregatedMetrics.getMetricsAggValueMap().get(timeoutConfig.getTimeoutMetric()).intValue();
        if (meanTimeoutValue <= 0) {
            return;
        }
        int newTimeout = currentTimeout = threadPool.getTimeout();
        Set<RevolverHttpApiConfig.RequestMethod> methods = api.getMethods();
        double timeoutBuffer = methods.isEmpty() || !methods.contains((Object)RevolverHttpApiConfig.RequestMethod.GET) ? timeoutConfig.getAllMethodTimeoutBuffer() : timeoutConfig.getGetMethodTimeoutBuffer();
        if (currentTimeout < meanTimeoutValue) {
            newTimeout = (int)((double)meanTimeoutValue * timeoutBuffer);
            configUpdated.set(true);
        } else if ((double)currentTimeout > (double)meanTimeoutValue * timeoutBuffer) {
            newTimeout = (int)((double)meanTimeoutValue * timeoutBuffer);
            configUpdated.set(true);
        }
        log.error("Setting timeout for : " + api.getApi() + " from : " + threadPool.getTimeout() + " to : " + newTimeout + ", meanTimeoutValue : " + meanTimeoutValue + ", with timeout buffer : " + timeoutBuffer);
        threadPool.setTimeout(newTimeout);
    }

    private void updateLatencySettings(RevolverHttpApiConfig api, OptimizerAggregatedMetrics optimizerAggregatedMetrics) {
        int meanLatency;
        int n = meanLatency = optimizerAggregatedMetrics.getMetricsAggValueMap().get("latencyExecute_percentile_50") == null ? 0 : optimizerAggregatedMetrics.getMetricsAggValueMap().get("latencyExecute_percentile_50").intValue();
        if (meanLatency <= 0) {
            return;
        }
        log.error("meanLatency : " + meanLatency + " for api : " + api);
        if (api.getLatencyConfig() == null) {
            api.setLatencyConfig(LatencyConfig.builder().build());
        }
        api.getLatencyConfig().setLatencyMetricValue(meanLatency);
    }

    public static RevolverConfigUpdaterBuilder builder() {
        return new RevolverConfigUpdaterBuilder();
    }

    public RevolverConfig getRevolverConfig() {
        return this.revolverConfig;
    }

    public OptimizerConfig getOptimizerConfig() {
        return this.optimizerConfig;
    }

    public OptimizerMetricsCache getOptimizerMetricsCache() {
        return this.optimizerMetricsCache;
    }

    public void setRevolverConfig(RevolverConfig revolverConfig) {
        this.revolverConfig = revolverConfig;
    }

    public void setOptimizerConfig(OptimizerConfig optimizerConfig) {
        this.optimizerConfig = optimizerConfig;
    }

    public void setOptimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverConfigUpdater)) {
            return false;
        }
        RevolverConfigUpdater other = (RevolverConfigUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RevolverConfig this$revolverConfig = this.getRevolverConfig();
        RevolverConfig other$revolverConfig = other.getRevolverConfig();
        if (this$revolverConfig == null ? other$revolverConfig != null : !((Object)((Object)this$revolverConfig)).equals((Object)other$revolverConfig)) {
            return false;
        }
        OptimizerConfig this$optimizerConfig = this.getOptimizerConfig();
        OptimizerConfig other$optimizerConfig = other.getOptimizerConfig();
        if (this$optimizerConfig == null ? other$optimizerConfig != null : !((Object)this$optimizerConfig).equals(other$optimizerConfig)) {
            return false;
        }
        OptimizerMetricsCache this$optimizerMetricsCache = this.getOptimizerMetricsCache();
        OptimizerMetricsCache other$optimizerMetricsCache = other.getOptimizerMetricsCache();
        return !(this$optimizerMetricsCache == null ? other$optimizerMetricsCache != null : !((Object)this$optimizerMetricsCache).equals(other$optimizerMetricsCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverConfigUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RevolverConfig $revolverConfig = this.getRevolverConfig();
        result = result * 59 + ($revolverConfig == null ? 43 : ((Object)((Object)$revolverConfig)).hashCode());
        OptimizerConfig $optimizerConfig = this.getOptimizerConfig();
        result = result * 59 + ($optimizerConfig == null ? 43 : ((Object)$optimizerConfig).hashCode());
        OptimizerMetricsCache $optimizerMetricsCache = this.getOptimizerMetricsCache();
        result = result * 59 + ($optimizerMetricsCache == null ? 43 : ((Object)$optimizerMetricsCache).hashCode());
        return result;
    }

    public String toString() {
        return "RevolverConfigUpdater(revolverConfig=" + (Object)((Object)this.getRevolverConfig()) + ", optimizerConfig=" + this.getOptimizerConfig() + ", optimizerMetricsCache=" + this.getOptimizerMetricsCache() + ")";
    }

    public RevolverConfigUpdater() {
    }

    public RevolverConfigUpdater(RevolverConfig revolverConfig, OptimizerConfig optimizerConfig, OptimizerMetricsCache optimizerMetricsCache) {
        this.revolverConfig = revolverConfig;
        this.optimizerConfig = optimizerConfig;
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public static class RevolverConfigUpdaterBuilder {
        private RevolverConfig revolverConfig;
        private OptimizerConfig optimizerConfig;
        private OptimizerMetricsCache optimizerMetricsCache;

        RevolverConfigUpdaterBuilder() {
        }

        public RevolverConfigUpdaterBuilder revolverConfig(RevolverConfig revolverConfig) {
            this.revolverConfig = revolverConfig;
            return this;
        }

        public RevolverConfigUpdaterBuilder optimizerConfig(OptimizerConfig optimizerConfig) {
            this.optimizerConfig = optimizerConfig;
            return this;
        }

        public RevolverConfigUpdaterBuilder optimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
            this.optimizerMetricsCache = optimizerMetricsCache;
            return this;
        }

        public RevolverConfigUpdater build() {
            return new RevolverConfigUpdater(this.revolverConfig, this.optimizerConfig, this.optimizerMetricsCache);
        }

        public String toString() {
            return "RevolverConfigUpdater.RevolverConfigUpdaterBuilder(revolverConfig=" + (Object)((Object)this.revolverConfig) + ", optimizerConfig=" + this.optimizerConfig + ", optimizerMetricsCache=" + this.optimizerMetricsCache + ")";
        }
    }
}

