/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer.config;

public class OptimizerConcurrencyConfig {
    private double maxThreshold = 0.85;
    private double minThreshold = 0.6;
    private double bandwidth = 1.2;

    public static OptimizerConcurrencyConfigBuilder builder() {
        return new OptimizerConcurrencyConfigBuilder();
    }

    public double getMaxThreshold() {
        return this.maxThreshold;
    }

    public double getMinThreshold() {
        return this.minThreshold;
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public void setMaxThreshold(double maxThreshold) {
        this.maxThreshold = maxThreshold;
    }

    public void setMinThreshold(double minThreshold) {
        this.minThreshold = minThreshold;
    }

    public void setBandwidth(double bandwidth) {
        this.bandwidth = bandwidth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerConcurrencyConfig)) {
            return false;
        }
        OptimizerConcurrencyConfig other = (OptimizerConcurrencyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMaxThreshold(), other.getMaxThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinThreshold(), other.getMinThreshold()) != 0) {
            return false;
        }
        return Double.compare(this.getBandwidth(), other.getBandwidth()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerConcurrencyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxThreshold = Double.doubleToLongBits(this.getMaxThreshold());
        result = result * 59 + (int)($maxThreshold >>> 32 ^ $maxThreshold);
        long $minThreshold = Double.doubleToLongBits(this.getMinThreshold());
        result = result * 59 + (int)($minThreshold >>> 32 ^ $minThreshold);
        long $bandwidth = Double.doubleToLongBits(this.getBandwidth());
        result = result * 59 + (int)($bandwidth >>> 32 ^ $bandwidth);
        return result;
    }

    public String toString() {
        return "OptimizerConcurrencyConfig(maxThreshold=" + this.getMaxThreshold() + ", minThreshold=" + this.getMinThreshold() + ", bandwidth=" + this.getBandwidth() + ")";
    }

    public OptimizerConcurrencyConfig(double maxThreshold, double minThreshold, double bandwidth) {
        this.maxThreshold = maxThreshold;
        this.minThreshold = minThreshold;
        this.bandwidth = bandwidth;
    }

    public OptimizerConcurrencyConfig() {
    }

    public static class OptimizerConcurrencyConfigBuilder {
        private double maxThreshold;
        private double minThreshold;
        private double bandwidth;

        OptimizerConcurrencyConfigBuilder() {
        }

        public OptimizerConcurrencyConfigBuilder maxThreshold(double maxThreshold) {
            this.maxThreshold = maxThreshold;
            return this;
        }

        public OptimizerConcurrencyConfigBuilder minThreshold(double minThreshold) {
            this.minThreshold = minThreshold;
            return this;
        }

        public OptimizerConcurrencyConfigBuilder bandwidth(double bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public OptimizerConcurrencyConfig build() {
            return new OptimizerConcurrencyConfig(this.maxThreshold, this.minThreshold, this.bandwidth);
        }

        public String toString() {
            return "OptimizerConcurrencyConfig.OptimizerConcurrencyConfigBuilder(maxThreshold=" + this.maxThreshold + ", minThreshold=" + this.minThreshold + ", bandwidth=" + this.bandwidth + ")";
        }
    }
}

