/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import io.dropwizard.revolver.optimizer.config.OptimizerMetricsCollectorConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.msgpack.jackson.dataformat.Tuple;

public class OptimizerMetricsCache {
    private static LinkedHashMap<Tuple<Long, String>, OptimizerMetrics> poolTimeBasedMetricsMap = new LinkedHashMap();
    private OptimizerMetricsCollectorConfig optimizerMetricsCollectorConfig;
    private LoadingCache<Tuple<Long, String>, OptimizerMetrics> cache;

    public OptimizerMetricsCache(OptimizerMetricsCollectorConfig optimizerMetricsCollectorConfig) {
        this.optimizerMetricsCollectorConfig = optimizerMetricsCollectorConfig;
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(optimizerMetricsCollectorConfig.getConcurrency()).expireAfterWrite((long)optimizerMetricsCollectorConfig.getCachingWindowInMinutes(), TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<Tuple<Long, String>, OptimizerMetrics>(){

            public void onRemoval(RemovalNotification<Tuple<Long, String>, OptimizerMetrics> notification) {
                poolTimeBasedMetricsMap.remove(notification.getKey());
            }
        }).build((CacheLoader)new CacheLoader<Tuple<Long, String>, OptimizerMetrics>(){

            public OptimizerMetrics load(@NonNull Tuple<Long, String> key) throws Exception {
                if (key == null) {
                    throw new NullPointerException("key is marked @NonNull but is null");
                }
                return (OptimizerMetrics)poolTimeBasedMetricsMap.get(key);
            }
        });
    }

    public OptimizerMetrics get(Tuple<Long, String> key) {
        try {
            return (OptimizerMetrics)this.cache.get(key);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error while getting value from the cache for the key : " + key);
        }
    }

    public void put(Tuple<Long, String> key, OptimizerMetrics value) {
        this.cache.put(key, (Object)value);
    }

    public Map<Tuple<Long, String>, OptimizerMetrics> getCache() {
        return Collections.unmodifiableMap(this.cache.asMap());
    }

    public static OptimizerMetricsCacheBuilder builder() {
        return new OptimizerMetricsCacheBuilder();
    }

    public OptimizerMetricsCollectorConfig getOptimizerMetricsCollectorConfig() {
        return this.optimizerMetricsCollectorConfig;
    }

    public void setOptimizerMetricsCollectorConfig(OptimizerMetricsCollectorConfig optimizerMetricsCollectorConfig) {
        this.optimizerMetricsCollectorConfig = optimizerMetricsCollectorConfig;
    }

    public void setCache(LoadingCache<Tuple<Long, String>, OptimizerMetrics> cache) {
        this.cache = cache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerMetricsCache)) {
            return false;
        }
        OptimizerMetricsCache other = (OptimizerMetricsCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OptimizerMetricsCollectorConfig this$optimizerMetricsCollectorConfig = this.getOptimizerMetricsCollectorConfig();
        OptimizerMetricsCollectorConfig other$optimizerMetricsCollectorConfig = other.getOptimizerMetricsCollectorConfig();
        if (this$optimizerMetricsCollectorConfig == null ? other$optimizerMetricsCollectorConfig != null : !((Object)this$optimizerMetricsCollectorConfig).equals(other$optimizerMetricsCollectorConfig)) {
            return false;
        }
        Map<Tuple<Long, String>, OptimizerMetrics> this$cache = this.getCache();
        Map<Tuple<Long, String>, OptimizerMetrics> other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerMetricsCache;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OptimizerMetricsCollectorConfig $optimizerMetricsCollectorConfig = this.getOptimizerMetricsCollectorConfig();
        result = result * 59 + ($optimizerMetricsCollectorConfig == null ? 43 : ((Object)$optimizerMetricsCollectorConfig).hashCode());
        Map<Tuple<Long, String>, OptimizerMetrics> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        return result;
    }

    public String toString() {
        return "OptimizerMetricsCache(optimizerMetricsCollectorConfig=" + this.getOptimizerMetricsCollectorConfig() + ", cache=" + this.getCache() + ")";
    }

    public OptimizerMetricsCache() {
    }

    public static class OptimizerMetricsCacheBuilder {
        private OptimizerMetricsCollectorConfig optimizerMetricsCollectorConfig;

        OptimizerMetricsCacheBuilder() {
        }

        public OptimizerMetricsCacheBuilder optimizerMetricsCollectorConfig(OptimizerMetricsCollectorConfig optimizerMetricsCollectorConfig) {
            this.optimizerMetricsCollectorConfig = optimizerMetricsCollectorConfig;
            return this;
        }

        public OptimizerMetricsCache build() {
            return new OptimizerMetricsCache(this.optimizerMetricsCollectorConfig);
        }

        public String toString() {
            return "OptimizerMetricsCache.OptimizerMetricsCacheBuilder(optimizerMetricsCollectorConfig=" + this.optimizerMetricsCollectorConfig + ")";
        }
    }
}

