/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.google.common.collect.Maps;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.optimizer.OptimizerAggregatedMetrics;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import io.dropwizard.revolver.optimizer.OptimizerMetricsCache;
import io.dropwizard.revolver.optimizer.config.OptimizerConcurrencyConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.msgpack.jackson.dataformat.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerConfigUpdater
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(OptimizerConfigUpdater.class);
    private RevolverConfig revolverConfig;
    private OptimizerConfig optimizerConfig;

    @Override
    public void run() {
        HashMap optimizerAggregatedMetricsMap = Maps.newHashMap();
        Map<Tuple<Long, String>, OptimizerMetrics> metricsCache = OptimizerMetricsCache.getCache();
        if (metricsCache.isEmpty()) {
            return;
        }
        metricsCache.forEach((tuple, optimizerMetrics) -> {
            if (optimizerAggregatedMetricsMap.get(tuple.second()) == null) {
                optimizerAggregatedMetricsMap.put(tuple.second(), OptimizerAggregatedMetrics.builder().pool((String)tuple.second()).metricsMaxValueMap(Maps.newHashMap()).build());
            }
            OptimizerAggregatedMetrics optimizerAggregatedMetrics = (OptimizerAggregatedMetrics)optimizerAggregatedMetricsMap.get(tuple.second());
            Map<String, Number> aggregatedMetricsValues = optimizerAggregatedMetrics.getMetricsMaxValueMap();
            optimizerMetrics.getMetrics().forEach((metric, value) -> {
                if (aggregatedMetricsValues.get(metric) == null || ((Number)aggregatedMetricsValues.get(metric)).intValue() < value.intValue()) {
                    log.error("Inputting into aggregated value : " + value.intValue() + ", for metric : " + metric + ", for key : " + (String)tuple.second());
                    aggregatedMetricsValues.put((String)metric, (Number)value);
                }
            });
        });
        this.updateRevolverConfig(optimizerAggregatedMetricsMap);
    }

    private void updateRevolverConfig(Map<String, OptimizerAggregatedMetrics> optimizerAggregatedMetricsMap) {
        AtomicBoolean configUpdated = new AtomicBoolean();
        this.revolverConfig.getServices().forEach(revolverServiceConfig -> {
            if (revolverServiceConfig.getThreadPoolGroupConfig() != null) {
                revolverServiceConfig.getThreadPoolGroupConfig().getThreadPools().forEach(threadPoolConfig -> this.updatedPoolSettings((ThreadPoolConfig)threadPoolConfig, optimizerAggregatedMetricsMap, configUpdated));
            }
            if (revolverServiceConfig instanceof RevolverHttpServiceConfig) {
                ((RevolverHttpServiceConfig)revolverServiceConfig).getApis().forEach(api -> this.updatedApiSettings((RevolverServiceConfig)revolverServiceConfig, (RevolverHttpApiConfig)api, optimizerAggregatedMetricsMap, configUpdated));
            }
        });
        if (configUpdated.get()) {
            log.error("Updating revolver config");
            RevolverBundle.loadServiceConfiguration(this.revolverConfig);
        }
    }

    private void updatedPoolSettings(ThreadPoolConfig threadPoolConfig, Map<String, OptimizerAggregatedMetrics> optimizerAggregatedMetricsMap, AtomicBoolean configUpdated) {
        OptimizerAggregatedMetrics optimizerAggregatedMetrics = optimizerAggregatedMetricsMap.get(threadPoolConfig.getThreadPoolName());
        if (optimizerAggregatedMetrics == null) {
            return;
        }
        this.updateConcurrencySetting(threadPoolConfig, optimizerAggregatedMetrics, configUpdated);
    }

    private void updatedApiSettings(RevolverServiceConfig revolverServiceConfig, RevolverHttpApiConfig api, Map<String, OptimizerAggregatedMetrics> optimizerAggregatedMetricsMap, AtomicBoolean configUpdated) {
        String key = revolverServiceConfig.getService() + "." + api.getApi();
        OptimizerAggregatedMetrics optimizerAggregatedMetrics = optimizerAggregatedMetricsMap.get(key);
        if (optimizerAggregatedMetrics == null) {
            return;
        }
        this.updateConcurrencySetting(api.getRuntime().getThreadPool(), optimizerAggregatedMetrics, configUpdated);
    }

    private void updateConcurrencySetting(ThreadPoolConfig threadPoolConfig, OptimizerAggregatedMetrics optimizerAggregatedMetrics, AtomicBoolean configUpdated) {
        int concurrency;
        if (optimizerAggregatedMetrics.getMetricsMaxValueMap().get("rollingMaxActiveThreads") == null) {
            return;
        }
        OptimizerConcurrencyConfig concurrencyConfig = this.optimizerConfig.getConcurrencyConfig();
        int maxRollingActiveThreads = optimizerAggregatedMetrics.getMetricsMaxValueMap().get("rollingMaxActiveThreads").intValue();
        if ((double)maxRollingActiveThreads > (double)(concurrency = threadPoolConfig.getConcurrency()) * concurrencyConfig.getMaxThreshold()) {
            concurrency = (int)Math.ceil((double)concurrency * concurrencyConfig.getIncreaseBy());
            configUpdated.set(true);
        } else if ((double)maxRollingActiveThreads < (double)concurrency * concurrencyConfig.getMinThreshold()) {
            if ((concurrency = (int)((double)concurrency * concurrencyConfig.getDecreaseBy())) <= 0) {
                return;
            }
            configUpdated.set(true);
        }
        log.error("Updating concurrency for pool : " + threadPoolConfig.getThreadPoolName() + " to value : " + concurrency + " from : " + threadPoolConfig.getConcurrency() + ", maxRollingActiveThreads : " + maxRollingActiveThreads);
        threadPoolConfig.setConcurrency(concurrency);
    }

    public static OptimizerConfigUpdaterBuilder builder() {
        return new OptimizerConfigUpdaterBuilder();
    }

    public RevolverConfig getRevolverConfig() {
        return this.revolverConfig;
    }

    public OptimizerConfig getOptimizerConfig() {
        return this.optimizerConfig;
    }

    public void setRevolverConfig(RevolverConfig revolverConfig) {
        this.revolverConfig = revolverConfig;
    }

    public void setOptimizerConfig(OptimizerConfig optimizerConfig) {
        this.optimizerConfig = optimizerConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerConfigUpdater)) {
            return false;
        }
        OptimizerConfigUpdater other = (OptimizerConfigUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RevolverConfig this$revolverConfig = this.getRevolverConfig();
        RevolverConfig other$revolverConfig = other.getRevolverConfig();
        if (this$revolverConfig == null ? other$revolverConfig != null : !((Object)((Object)this$revolverConfig)).equals((Object)other$revolverConfig)) {
            return false;
        }
        OptimizerConfig this$optimizerConfig = this.getOptimizerConfig();
        OptimizerConfig other$optimizerConfig = other.getOptimizerConfig();
        return !(this$optimizerConfig == null ? other$optimizerConfig != null : !((Object)this$optimizerConfig).equals(other$optimizerConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerConfigUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RevolverConfig $revolverConfig = this.getRevolverConfig();
        result = result * 59 + ($revolverConfig == null ? 43 : ((Object)((Object)$revolverConfig)).hashCode());
        OptimizerConfig $optimizerConfig = this.getOptimizerConfig();
        result = result * 59 + ($optimizerConfig == null ? 43 : ((Object)$optimizerConfig).hashCode());
        return result;
    }

    public String toString() {
        return "OptimizerConfigUpdater(revolverConfig=" + (Object)((Object)this.getRevolverConfig()) + ", optimizerConfig=" + this.getOptimizerConfig() + ")";
    }

    public OptimizerConfigUpdater() {
    }

    public OptimizerConfigUpdater(RevolverConfig revolverConfig, OptimizerConfig optimizerConfig) {
        this.revolverConfig = revolverConfig;
        this.optimizerConfig = optimizerConfig;
    }

    public static class OptimizerConfigUpdaterBuilder {
        private RevolverConfig revolverConfig;
        private OptimizerConfig optimizerConfig;

        OptimizerConfigUpdaterBuilder() {
        }

        public OptimizerConfigUpdaterBuilder revolverConfig(RevolverConfig revolverConfig) {
            this.revolverConfig = revolverConfig;
            return this;
        }

        public OptimizerConfigUpdaterBuilder optimizerConfig(OptimizerConfig optimizerConfig) {
            this.optimizerConfig = optimizerConfig;
            return this;
        }

        public OptimizerConfigUpdater build() {
            return new OptimizerConfigUpdater(this.revolverConfig, this.optimizerConfig);
        }

        public String toString() {
            return "OptimizerConfigUpdater.OptimizerConfigUpdaterBuilder(revolverConfig=" + (Object)((Object)this.revolverConfig) + ", optimizerConfig=" + this.optimizerConfig + ")";
        }
    }
}

