package io.dropwizard.revolver.optimizer.utils;

import com.google.common.collect.Lists;

import java.util.Collections;
import java.util.List;

/***
 Created by nitish.goyal on 29/03/19
 ***/
public class OptimizerUtils {

    public static final String ROLLING_MAX_ACTIVE_THREADS = "rollingMaxActiveThreads";
    public static final String PREFIX = "HystrixThreadPool";

    private static final List<String> METRICS_TO_READ = Lists.newArrayList("propertyValue_maximumSize", ROLLING_MAX_ACTIVE_THREADS);

    public static List<String> getMetricsToRead() {
        return Collections.unmodifiableList(METRICS_TO_READ);
    }
}
