/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.msgpack.jackson.dataformat.Tuple;

public class OptimizerMetricsCache {
    private static LinkedHashMap<Tuple<Long, String>, OptimizerMetrics> poolTimeBasedMetricsMap = new LinkedHashMap();
    private static LoadingCache<Tuple<Long, String>, OptimizerMetrics> cache = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterWrite(30L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<Tuple<Long, String>, OptimizerMetrics>(){

        public void onRemoval(RemovalNotification<Tuple<Long, String>, OptimizerMetrics> notification) {
            poolTimeBasedMetricsMap.remove(notification.getKey());
        }
    }).build((CacheLoader)new CacheLoader<Tuple<Long, String>, OptimizerMetrics>(){

        public OptimizerMetrics load(@NonNull Tuple<Long, String> key) throws Exception {
            if (key == null) {
                throw new NullPointerException("key is marked @NonNull but is null");
            }
            return (OptimizerMetrics)poolTimeBasedMetricsMap.get(key);
        }
    });

    public static OptimizerMetrics get(Tuple<Long, String> key) {
        try {
            return (OptimizerMetrics)cache.get(key);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error while getting value from the cache for the key : " + key);
        }
    }

    public static void put(Tuple<Long, String> key, OptimizerMetrics value) {
        cache.put(key, (Object)value);
    }

    public static Map<Tuple<Long, String>, OptimizerMetrics> getCache() {
        return Collections.unmodifiableMap(cache.asMap());
    }
}

