/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer.config;

public class OptimizerConcurrencyConfig {
    private double maxThreshold = 0.7;
    private double minThreshold = 0.6;
    private double increaseBy = 1.2;
    private double decreaseBy = 0.8;

    public double getMaxThreshold() {
        return this.maxThreshold;
    }

    public double getMinThreshold() {
        return this.minThreshold;
    }

    public double getIncreaseBy() {
        return this.increaseBy;
    }

    public double getDecreaseBy() {
        return this.decreaseBy;
    }

    public void setMaxThreshold(double maxThreshold) {
        this.maxThreshold = maxThreshold;
    }

    public void setMinThreshold(double minThreshold) {
        this.minThreshold = minThreshold;
    }

    public void setIncreaseBy(double increaseBy) {
        this.increaseBy = increaseBy;
    }

    public void setDecreaseBy(double decreaseBy) {
        this.decreaseBy = decreaseBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerConcurrencyConfig)) {
            return false;
        }
        OptimizerConcurrencyConfig other = (OptimizerConcurrencyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMaxThreshold(), other.getMaxThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinThreshold(), other.getMinThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getIncreaseBy(), other.getIncreaseBy()) != 0) {
            return false;
        }
        return Double.compare(this.getDecreaseBy(), other.getDecreaseBy()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerConcurrencyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxThreshold = Double.doubleToLongBits(this.getMaxThreshold());
        result = result * 59 + (int)($maxThreshold >>> 32 ^ $maxThreshold);
        long $minThreshold = Double.doubleToLongBits(this.getMinThreshold());
        result = result * 59 + (int)($minThreshold >>> 32 ^ $minThreshold);
        long $increaseBy = Double.doubleToLongBits(this.getIncreaseBy());
        result = result * 59 + (int)($increaseBy >>> 32 ^ $increaseBy);
        long $decreaseBy = Double.doubleToLongBits(this.getDecreaseBy());
        result = result * 59 + (int)($decreaseBy >>> 32 ^ $decreaseBy);
        return result;
    }

    public String toString() {
        return "OptimizerConcurrencyConfig(maxThreshold=" + this.getMaxThreshold() + ", minThreshold=" + this.getMinThreshold() + ", increaseBy=" + this.getIncreaseBy() + ", decreaseBy=" + this.getDecreaseBy() + ")";
    }
}

