/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import io.dropwizard.revolver.optimizer.OptimizerMetricsCache;
import io.dropwizard.revolver.optimizer.utils.OptimizerUtils;
import java.util.SortedMap;
import org.msgpack.jackson.dataformat.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerMetricsBuilder
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(OptimizerMetricsBuilder.class);
    private static final String PREFIX = "HystrixThreadPool";
    private MetricRegistry metrics;

    @Override
    public void run() {
        Long time = System.currentTimeMillis();
        SortedMap gauges = this.metrics.getGauges(MetricFilter.startsWith((String)PREFIX));
        gauges.forEach((k, v) -> {
            String[] splits = k.split("\\.");
            if (splits.length < 3) {
                return;
            }
            int length = splits.length;
            String metricName = splits[length - 1];
            if (!OptimizerUtils.getMetricsToRead().contains(metricName) || !(v.getValue() instanceof Integer)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            String delimiter = "";
            for (int i = 1; i < length - 1; ++i) {
                sb.append(delimiter);
                sb.append(splits[i]);
                delimiter = ".";
            }
            Tuple key = new Tuple((Object)time, (Object)sb.toString());
            if (OptimizerMetricsCache.get((Tuple<Long, String>)key) == null) {
                OptimizerMetricsCache.put((Tuple<Long, String>)key, OptimizerMetrics.builder().metrics(Maps.newHashMap()).build());
            }
            OptimizerMetrics optimizerMetrics = OptimizerMetricsCache.get((Tuple<Long, String>)key);
            optimizerMetrics.getMetrics().put(metricName, (Integer)v.getValue());
        });
    }

    public static OptimizerMetricsBuilderBuilder builder() {
        return new OptimizerMetricsBuilderBuilder();
    }

    public OptimizerMetricsBuilder(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public void setMetrics(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerMetricsBuilder)) {
            return false;
        }
        OptimizerMetricsBuilder other = (OptimizerMetricsBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricRegistry this$metrics = this.getMetrics();
        MetricRegistry other$metrics = other.getMetrics();
        return !(this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerMetricsBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetricRegistry $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        return result;
    }

    public String toString() {
        return "OptimizerMetricsBuilder(metrics=" + this.getMetrics() + ")";
    }

    public static class OptimizerMetricsBuilderBuilder {
        private MetricRegistry metrics;

        OptimizerMetricsBuilderBuilder() {
        }

        public OptimizerMetricsBuilderBuilder metrics(MetricRegistry metrics) {
            this.metrics = metrics;
            return this;
        }

        public OptimizerMetricsBuilder build() {
            return new OptimizerMetricsBuilder(this.metrics);
        }

        public String toString() {
            return "OptimizerMetricsBuilder.OptimizerMetricsBuilderBuilder(metrics=" + this.metrics + ")";
        }
    }
}

