/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.google.common.collect.Maps;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.optimizer.OptimizerAggregatedMetrics;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import io.dropwizard.revolver.optimizer.OptimizerMetricsCache;
import io.dropwizard.revolver.optimizer.config.OptimizerConcurrencyConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerConfig;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.jackson.dataformat.Tuple;

public class OptimizerConfigUpdater
implements Runnable {
    private RevolverConfig revolverConfig;
    private OptimizerConfig optimizerConfig;

    @Override
    public void run() {
        HashMap optimizerAggregatedMetricsMap = Maps.newHashMap();
        Map<Tuple<Long, String>, OptimizerMetrics> metricsCache = OptimizerMetricsCache.getCache();
        metricsCache.forEach((tuple, optimizerMetrics) -> {
            if (optimizerAggregatedMetricsMap.get(tuple.second()) == null) {
                optimizerAggregatedMetricsMap.put(tuple.second(), OptimizerAggregatedMetrics.builder().pool((String)tuple.second()).build());
            }
            OptimizerAggregatedMetrics optimizerAggregatedMetrics = (OptimizerAggregatedMetrics)optimizerAggregatedMetricsMap.get(tuple.second());
            Map<String, Integer> aggregatedMetricsValues = optimizerAggregatedMetrics.getMetricsMaxValueMap();
            optimizerMetrics.getMetrics().forEach((metric, value) -> {
                if (aggregatedMetricsValues.get(metric) == null || (Integer)aggregatedMetricsValues.get(metric) < value) {
                    aggregatedMetricsValues.put((String)metric, (Integer)value);
                }
            });
        });
        this.updateRevolverConfig(optimizerAggregatedMetricsMap);
    }

    private void updateRevolverConfig(Map<String, OptimizerAggregatedMetrics> optimizerAggregatedMetricsMap) {
        this.revolverConfig.getServices().forEach(revolverServiceConfig -> {
            if (revolverServiceConfig.getThreadPoolGroupConfig() == null) {
                return;
            }
            revolverServiceConfig.getThreadPoolGroupConfig().getThreadPools().forEach(threadPoolConfig -> this.updatedPoolSettings((ThreadPoolConfig)threadPoolConfig, optimizerAggregatedMetricsMap));
        });
        RevolverBundle.loadServiceConfiguration(this.revolverConfig);
    }

    private void updatedPoolSettings(ThreadPoolConfig threadPoolConfig, Map<String, OptimizerAggregatedMetrics> optimizerAggregatedMetricsMap) {
        OptimizerAggregatedMetrics optimizerAggregatedMetrics = optimizerAggregatedMetricsMap.get(threadPoolConfig.getThreadPoolName());
        if (optimizerAggregatedMetrics == null) {
            return;
        }
        this.updateConcurrencySetting(threadPoolConfig, optimizerAggregatedMetrics);
    }

    private void updateConcurrencySetting(ThreadPoolConfig threadPoolConfig, OptimizerAggregatedMetrics optimizerAggregatedMetrics) {
        int concurrency;
        if (optimizerAggregatedMetrics.getMetricsMaxValueMap().get("rollingMaxActiveThreads") == null) {
            return;
        }
        OptimizerConcurrencyConfig concurrencyConfig = this.optimizerConfig.getConcurrencyConfig();
        int maxRollingActiveThreads = optimizerAggregatedMetrics.getMetricsMaxValueMap().get("rollingMaxActiveThreads");
        if ((double)maxRollingActiveThreads > (double)(concurrency = threadPoolConfig.getConcurrency()) * concurrencyConfig.getMaxThreshold()) {
            concurrency = (int)((double)concurrency * concurrencyConfig.getIncreaseBy());
        } else if ((double)maxRollingActiveThreads < (double)concurrency * concurrencyConfig.getMinThreshold()) {
            concurrency = (int)((double)concurrency * concurrencyConfig.getDecreaseBy());
        }
        threadPoolConfig.setConcurrency(concurrency);
    }

    public static OptimizerConfigUpdaterBuilder builder() {
        return new OptimizerConfigUpdaterBuilder();
    }

    public RevolverConfig getRevolverConfig() {
        return this.revolverConfig;
    }

    public OptimizerConfig getOptimizerConfig() {
        return this.optimizerConfig;
    }

    public void setRevolverConfig(RevolverConfig revolverConfig) {
        this.revolverConfig = revolverConfig;
    }

    public void setOptimizerConfig(OptimizerConfig optimizerConfig) {
        this.optimizerConfig = optimizerConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerConfigUpdater)) {
            return false;
        }
        OptimizerConfigUpdater other = (OptimizerConfigUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RevolverConfig this$revolverConfig = this.getRevolverConfig();
        RevolverConfig other$revolverConfig = other.getRevolverConfig();
        if (this$revolverConfig == null ? other$revolverConfig != null : !((Object)((Object)this$revolverConfig)).equals((Object)other$revolverConfig)) {
            return false;
        }
        OptimizerConfig this$optimizerConfig = this.getOptimizerConfig();
        OptimizerConfig other$optimizerConfig = other.getOptimizerConfig();
        return !(this$optimizerConfig == null ? other$optimizerConfig != null : !((Object)this$optimizerConfig).equals(other$optimizerConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerConfigUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RevolverConfig $revolverConfig = this.getRevolverConfig();
        result = result * 59 + ($revolverConfig == null ? 43 : ((Object)((Object)$revolverConfig)).hashCode());
        OptimizerConfig $optimizerConfig = this.getOptimizerConfig();
        result = result * 59 + ($optimizerConfig == null ? 43 : ((Object)$optimizerConfig).hashCode());
        return result;
    }

    public String toString() {
        return "OptimizerConfigUpdater(revolverConfig=" + (Object)((Object)this.getRevolverConfig()) + ", optimizerConfig=" + this.getOptimizerConfig() + ")";
    }

    public OptimizerConfigUpdater() {
    }

    public OptimizerConfigUpdater(RevolverConfig revolverConfig, OptimizerConfig optimizerConfig) {
        this.revolverConfig = revolverConfig;
        this.optimizerConfig = optimizerConfig;
    }

    public static class OptimizerConfigUpdaterBuilder {
        private RevolverConfig revolverConfig;
        private OptimizerConfig optimizerConfig;

        OptimizerConfigUpdaterBuilder() {
        }

        public OptimizerConfigUpdaterBuilder revolverConfig(RevolverConfig revolverConfig) {
            this.revolverConfig = revolverConfig;
            return this;
        }

        public OptimizerConfigUpdaterBuilder optimizerConfig(OptimizerConfig optimizerConfig) {
            this.optimizerConfig = optimizerConfig;
            return this;
        }

        public OptimizerConfigUpdater build() {
            return new OptimizerConfigUpdater(this.revolverConfig, this.optimizerConfig);
        }

        public String toString() {
            return "OptimizerConfigUpdater.OptimizerConfigUpdaterBuilder(revolverConfig=" + (Object)((Object)this.revolverConfig) + ", optimizerConfig=" + this.optimizerConfig + ")";
        }
    }
}

