package io.dropwizard.revolver.optimizer;

import com.google.common.cache.*;
import lombok.NonNull;
import org.msgpack.jackson.dataformat.Tuple;

import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;

/***
 Created by nitish.goyal on 29/03/19
 ***/
public class OptimizerMetricsCache {

    private static LinkedHashMap<Tuple<Long, String>, OptimizerMetrics> poolTimeBasedMetricsMap = new LinkedHashMap<>();

    private static LoadingCache<Tuple<Long, String>, OptimizerMetrics> cache = CacheBuilder.newBuilder()
            .concurrencyLevel(4)
            .expireAfterWrite(30, TimeUnit.MINUTES)
            .removalListener(new RemovalListener<Tuple<Long, String>, OptimizerMetrics>() {
                @Override
                public void onRemoval(RemovalNotification<Tuple<Long, String>, OptimizerMetrics> notification) {
                    poolTimeBasedMetricsMap.remove(notification.getKey());
                }
            })
            .build(new CacheLoader<Tuple<Long, String>, OptimizerMetrics>() {
                @Override
                public OptimizerMetrics load(@NonNull Tuple<Long, String> key) throws Exception {
                    return poolTimeBasedMetricsMap.get(key);
                }
            });

    public static void put(Tuple<Long, String> key, OptimizerMetrics value) {
        poolTimeBasedMetricsMap.put(key, value);
    }

    public static OptimizerMetrics get(Tuple<Long, String> key) {
        return poolTimeBasedMetricsMap.get(key);
    }
}
