/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core;

import io.dropwizard.revolver.core.HystrixCommandHandler;
import io.dropwizard.revolver.core.RevolverContext;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.SentinelCommandHandler;
import io.dropwizard.revolver.core.config.ClientConfig;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.RuntimeConfig;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.model.RevolverResponse;
import io.dropwizard.revolver.core.tracing.TraceInfo;
import io.dropwizard.revolver.core.util.HystroxCommandHelper;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public abstract class RevolverCommand<RequestType extends RevolverRequest, ResponseType extends RevolverResponse, ContextType extends RevolverContext, ServiceConfigurationType extends RevolverServiceConfig, CommandHandlerConfigType extends CommandHandlerConfig> {
    private static final Logger log = LoggerFactory.getLogger(RevolverCommand.class);
    private final ContextType context;
    private final RuntimeConfig runtimeConfig;
    private final ServiceConfigurationType serviceConfiguration;
    private final CommandHandlerConfigType apiConfiguration;
    private ClientConfig clientConfiguration;

    public RevolverCommand(ContextType context, ClientConfig clientConfiguration, RuntimeConfig runtimeConfig, ServiceConfigurationType serviceConfiguration, CommandHandlerConfigType apiConfiguration) {
        this.context = context;
        this.clientConfiguration = clientConfiguration;
        this.runtimeConfig = runtimeConfig;
        this.serviceConfiguration = serviceConfiguration;
        this.apiConfiguration = apiConfiguration;
    }

    public ResponseType execute(RequestType request) throws RevolverExecutionException, TimeoutException {
        RequestType normalizedRequest = RevolverCommandHelper.normalize(request);
        TraceInfo traceInfo = ((RevolverRequest)normalizedRequest).getTrace();
        RevolverCommandHelper.addContextInfo(RevolverCommandHelper.getName(request), traceInfo);
        try {
            Object response;
            RevolverExecutorType revolverExecutorType = ((RevolverRequest)request).getRevolverExecutorType();
            switch (revolverExecutorType) {
                case SENTINEL: {
                    response = new SentinelCommandHandler(this.context, this, normalizedRequest).executeSync();
                    break;
                }
                default: {
                    response = (RevolverResponse)new HystrixCommandHandler(HystroxCommandHelper.setter(this, ((RevolverRequest)request).getApi()), this.context, this, normalizedRequest).execute();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Command response: " + response);
            }
            return response;
        }
        catch (Throwable t) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
            log.error("Error occurred while executing revolver command for service : " + ((RevolverRequest)request).getService() + ", for api : " + ((RevolverRequest)request).getApi() + " with error : " + t);
            if (rootCause == null) {
                rootCause = t;
            }
            if (rootCause instanceof TimeoutException) {
                throw (TimeoutException)rootCause;
            }
            throw new RevolverExecutionException(RevolverExecutionException.Type.SERVICE_ERROR, rootCause);
        }
    }

    public CompletableFuture<ResponseType> executeAsync(RequestType request) {
        RequestType normalizedRequest = RevolverCommandHelper.normalize(request);
        TraceInfo traceInfo = ((RevolverRequest)normalizedRequest).getTrace();
        RevolverCommandHelper.addContextInfo(RevolverCommandHelper.getName(request), traceInfo);
        RevolverExecutorType revolverExecutorType = ((RevolverRequest)request).getRevolverExecutorType();
        switch (revolverExecutorType) {
            case SENTINEL: {
                return new SentinelCommandHandler(this.context, this, request).executeASync();
            }
        }
        return new HystrixCommandHandler(HystroxCommandHelper.setter(this, ((RevolverRequest)request).getApi()), this.context, this, normalizedRequest).executeAsync();
    }

    public Observable<ResponseType> executeAsyncAsObservable(RequestType request) {
        RequestType normalizedRequest = RevolverCommandHelper.normalize(request);
        TraceInfo traceInfo = ((RevolverRequest)normalizedRequest).getTrace();
        RevolverCommandHelper.addContextInfo(RevolverCommandHelper.getName(request), traceInfo);
        RevolverExecutorType revolverExecutorType = ((RevolverRequest)request).getRevolverExecutorType();
        switch (revolverExecutorType) {
            case SENTINEL: {
                return new SentinelCommandHandler(this.context, this, request).executeAsyncAsObservable();
            }
        }
        return new HystrixCommandHandler(HystroxCommandHelper.setter(this, ((RevolverRequest)request).getApi()), this.context, this, normalizedRequest).toObservable();
    }

    public boolean isFallbackEnabled() {
        return true;
    }

    public abstract ResponseType execute(ContextType var1, RequestType var2) throws Exception;

    protected abstract ResponseType fallback(ContextType var1, RequestType var2);

    protected ClientConfig getClientConfiguration() {
        return this.clientConfiguration;
    }

    public RuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    public ServiceConfigurationType getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public CommandHandlerConfigType getApiConfiguration() {
        return this.apiConfiguration;
    }
}

