/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.retry;

import io.dropwizard.revolver.retry.WaitStrategy;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;

public class RevolverApiRetryConfig {
    public static final int MAX_RETRY = 3;
    public static final int MAXIMUM_WAIT_TIME_IN_SECONDS = 10;
    public static final long INCREMENT_BY_IN_MILLIS = 200L;
    @NotNull
    private boolean enabled;
    @DefaultValue(value="3")
    private int maxRetry = 3;
    @DefaultValue(value="EXPONENTIAL")
    private WaitStrategy waitStrategy = WaitStrategy.EXPONENTIAL;
    @DefaultValue(value="10")
    private int maximumTimeInSeconds = 10;
    @DefaultValue(value="200")
    private long incrementByInMillis = 200L;

    public RevolverApiRetryConfig(boolean enabled, int maxRetry, WaitStrategy waitStrategy, int maximumTimeInSeconds, long incrementByInMillis) {
        this.enabled = enabled;
        this.maxRetry = maxRetry;
        this.waitStrategy = waitStrategy;
        this.maximumTimeInSeconds = maximumTimeInSeconds;
        this.incrementByInMillis = incrementByInMillis;
    }

    public static RevolverApiRetryConfigBuilder builder() {
        return new RevolverApiRetryConfigBuilder();
    }

    public static RevolverApiRetryConfigBuilder configBuilder() {
        return new RevolverApiRetryConfigBuilder();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public int getMaximumTimeInSeconds() {
        return this.maximumTimeInSeconds;
    }

    public long getIncrementByInMillis() {
        return this.incrementByInMillis;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public void setWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    public void setMaximumTimeInSeconds(int maximumTimeInSeconds) {
        this.maximumTimeInSeconds = maximumTimeInSeconds;
    }

    public void setIncrementByInMillis(long incrementByInMillis) {
        this.incrementByInMillis = incrementByInMillis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverApiRetryConfig)) {
            return false;
        }
        RevolverApiRetryConfig other = (RevolverApiRetryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getMaxRetry() != other.getMaxRetry()) {
            return false;
        }
        WaitStrategy this$waitStrategy = this.getWaitStrategy();
        WaitStrategy other$waitStrategy = other.getWaitStrategy();
        if (this$waitStrategy == null ? other$waitStrategy != null : !((Object)((Object)this$waitStrategy)).equals((Object)other$waitStrategy)) {
            return false;
        }
        if (this.getMaximumTimeInSeconds() != other.getMaximumTimeInSeconds()) {
            return false;
        }
        return this.getIncrementByInMillis() == other.getIncrementByInMillis();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverApiRetryConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getMaxRetry();
        WaitStrategy $waitStrategy = this.getWaitStrategy();
        result = result * 59 + ($waitStrategy == null ? 43 : ((Object)((Object)$waitStrategy)).hashCode());
        result = result * 59 + this.getMaximumTimeInSeconds();
        long $incrementByInMillis = this.getIncrementByInMillis();
        result = result * 59 + (int)($incrementByInMillis >>> 32 ^ $incrementByInMillis);
        return result;
    }

    public String toString() {
        return "RevolverApiRetryConfig(enabled=" + this.isEnabled() + ", maxRetry=" + this.getMaxRetry() + ", waitStrategy=" + (Object)((Object)this.getWaitStrategy()) + ", maximumTimeInSeconds=" + this.getMaximumTimeInSeconds() + ", incrementByInMillis=" + this.getIncrementByInMillis() + ")";
    }

    public RevolverApiRetryConfig() {
    }

    public static class RevolverApiRetryConfigBuilder {
        private boolean enabled;
        private int maxRetry;
        private WaitStrategy waitStrategy;
        private int maximumTimeInSeconds;
        private long incrementByInMillis;

        RevolverApiRetryConfigBuilder() {
        }

        public RevolverApiRetryConfigBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public RevolverApiRetryConfigBuilder maxRetry(int maxRetry) {
            this.maxRetry = maxRetry;
            return this;
        }

        public RevolverApiRetryConfigBuilder waitStrategy(WaitStrategy waitStrategy) {
            this.waitStrategy = waitStrategy;
            return this;
        }

        public RevolverApiRetryConfigBuilder maximumTimeInSeconds(int maximumTimeInSeconds) {
            this.maximumTimeInSeconds = maximumTimeInSeconds;
            return this;
        }

        public RevolverApiRetryConfigBuilder incrementByInMillis(long incrementByInMillis) {
            this.incrementByInMillis = incrementByInMillis;
            return this;
        }

        public RevolverApiRetryConfig build() {
            return new RevolverApiRetryConfig(this.enabled, this.maxRetry, this.waitStrategy, this.maximumTimeInSeconds, this.incrementByInMillis);
        }

        public String toString() {
            return "RevolverApiRetryConfig.RevolverApiRetryConfigBuilder(enabled=" + this.enabled + ", maxRetry=" + this.maxRetry + ", waitStrategy=" + (Object)((Object)this.waitStrategy) + ", maximumTimeInSeconds=" + this.maximumTimeInSeconds + ", incrementByInMillis=" + this.incrementByInMillis + ")";
        }
    }
}

