/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http.config;

import io.dropwizard.actors.actor.ActorConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.ThreadPoolGroupConfig;
import io.dropwizard.revolver.discovery.EndpointSpec;
import io.dropwizard.revolver.http.auth.AuthConfig;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class RevolverHttpsServiceConfig
extends RevolverServiceConfig {
    @NotNull
    @Valid
    private EndpointSpec endpoint;
    private int connectionPoolSize;
    private boolean authEnabled;
    private AuthConfig auth;
    private String keyStorePath;
    private String keystorePassword;
    private Set<RevolverHttpApiConfig> apis;
    private boolean trackingHeaders;
    private boolean compression;
    private int connectionKeepAliveInMillis = 60000;

    public RevolverHttpsServiceConfig(String type, String service, EndpointSpec enpoint, int connectionPoolSize, boolean authEnabled, AuthConfig auth, String keyStorePath, String keystorePassword, Set<RevolverHttpApiConfig> apis, boolean trackingHeaders, boolean compression, int connectionKeepAliveInMillis, ThreadPoolGroupConfig threadPoolGroupConfig, Map<String, ActorConfig> actors) {
        super(type, service);
        this.endpoint = enpoint;
        this.connectionPoolSize = connectionPoolSize;
        this.authEnabled = authEnabled;
        this.auth = auth;
        this.keyStorePath = keyStorePath;
        this.keystorePassword = keystorePassword;
        this.apis = apis;
        this.trackingHeaders = trackingHeaders;
        this.compression = compression;
        this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
        this.threadPoolGroupConfig = threadPoolGroupConfig;
        this.actors = actors;
    }

    public static RevolverHttpsServiceConfigBuilder builder() {
        return new RevolverHttpsServiceConfigBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverHttpsServiceConfig)) {
            return false;
        }
        RevolverHttpsServiceConfig other = (RevolverHttpsServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointSpec this$endpoint = this.getEndpoint();
        EndpointSpec other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        if (this.getConnectionPoolSize() != other.getConnectionPoolSize()) {
            return false;
        }
        if (this.isAuthEnabled() != other.isAuthEnabled()) {
            return false;
        }
        AuthConfig this$auth = this.getAuth();
        AuthConfig other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        String this$keyStorePath = this.getKeyStorePath();
        String other$keyStorePath = other.getKeyStorePath();
        if (this$keyStorePath == null ? other$keyStorePath != null : !this$keyStorePath.equals(other$keyStorePath)) {
            return false;
        }
        String this$keystorePassword = this.getKeystorePassword();
        String other$keystorePassword = other.getKeystorePassword();
        if (this$keystorePassword == null ? other$keystorePassword != null : !this$keystorePassword.equals(other$keystorePassword)) {
            return false;
        }
        Set<RevolverHttpApiConfig> this$apis = this.getApis();
        Set<RevolverHttpApiConfig> other$apis = other.getApis();
        if (this$apis == null ? other$apis != null : !((Object)this$apis).equals(other$apis)) {
            return false;
        }
        if (this.isTrackingHeaders() != other.isTrackingHeaders()) {
            return false;
        }
        if (this.isCompression() != other.isCompression()) {
            return false;
        }
        return this.getConnectionKeepAliveInMillis() == other.getConnectionKeepAliveInMillis();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RevolverHttpsServiceConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EndpointSpec $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        result = result * 59 + this.getConnectionPoolSize();
        result = result * 59 + (this.isAuthEnabled() ? 79 : 97);
        AuthConfig $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        String $keyStorePath = this.getKeyStorePath();
        result = result * 59 + ($keyStorePath == null ? 43 : $keyStorePath.hashCode());
        String $keystorePassword = this.getKeystorePassword();
        result = result * 59 + ($keystorePassword == null ? 43 : $keystorePassword.hashCode());
        Set<RevolverHttpApiConfig> $apis = this.getApis();
        result = result * 59 + ($apis == null ? 43 : ((Object)$apis).hashCode());
        result = result * 59 + (this.isTrackingHeaders() ? 79 : 97);
        result = result * 59 + (this.isCompression() ? 79 : 97);
        result = result * 59 + this.getConnectionKeepAliveInMillis();
        return result;
    }

    public EndpointSpec getEndpoint() {
        return this.endpoint;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public AuthConfig getAuth() {
        return this.auth;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public Set<RevolverHttpApiConfig> getApis() {
        return this.apis;
    }

    public boolean isTrackingHeaders() {
        return this.trackingHeaders;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public int getConnectionKeepAliveInMillis() {
        return this.connectionKeepAliveInMillis;
    }

    public void setEndpoint(EndpointSpec endpoint) {
        this.endpoint = endpoint;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public void setAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
    }

    public void setAuth(AuthConfig auth) {
        this.auth = auth;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setApis(Set<RevolverHttpApiConfig> apis) {
        this.apis = apis;
    }

    public void setTrackingHeaders(boolean trackingHeaders) {
        this.trackingHeaders = trackingHeaders;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public void setConnectionKeepAliveInMillis(int connectionKeepAliveInMillis) {
        this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
    }

    @Override
    public String toString() {
        return "RevolverHttpsServiceConfig(endpoint=" + this.getEndpoint() + ", connectionPoolSize=" + this.getConnectionPoolSize() + ", authEnabled=" + this.isAuthEnabled() + ", auth=" + this.getAuth() + ", keyStorePath=" + this.getKeyStorePath() + ", keystorePassword=" + this.getKeystorePassword() + ", apis=" + this.getApis() + ", trackingHeaders=" + this.isTrackingHeaders() + ", compression=" + this.isCompression() + ", connectionKeepAliveInMillis=" + this.getConnectionKeepAliveInMillis() + ")";
    }

    public RevolverHttpsServiceConfig(EndpointSpec endpoint, int connectionPoolSize, boolean authEnabled, AuthConfig auth, String keyStorePath, String keystorePassword, Set<RevolverHttpApiConfig> apis, boolean trackingHeaders, boolean compression, int connectionKeepAliveInMillis) {
        this.endpoint = endpoint;
        this.connectionPoolSize = connectionPoolSize;
        this.authEnabled = authEnabled;
        this.auth = auth;
        this.keyStorePath = keyStorePath;
        this.keystorePassword = keystorePassword;
        this.apis = apis;
        this.trackingHeaders = trackingHeaders;
        this.compression = compression;
        this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
    }

    public RevolverHttpsServiceConfig() {
    }

    public static class RevolverHttpsServiceConfigBuilder {
        private String type;
        private String service;
        private EndpointSpec enpoint;
        private int connectionPoolSize;
        private boolean authEnabled;
        private AuthConfig auth;
        private String keyStorePath;
        private String keystorePassword;
        private ArrayList<RevolverHttpApiConfig> apis;
        private boolean trackingHeaders;
        private boolean compression;
        private int connectionKeepAliveInMillis;
        private ThreadPoolGroupConfig threadPoolGroupConfig;
        private Map<String, ActorConfig> actors;

        RevolverHttpsServiceConfigBuilder() {
        }

        public RevolverHttpsServiceConfigBuilder type(String type) {
            this.type = type;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder service(String service) {
            this.service = service;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder enpoint(EndpointSpec enpoint) {
            this.enpoint = enpoint;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder connectionPoolSize(int connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder authEnabled(boolean authEnabled) {
            this.authEnabled = authEnabled;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder auth(AuthConfig auth) {
            this.auth = auth;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder keystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder api(RevolverHttpApiConfig api) {
            if (this.apis == null) {
                this.apis = new ArrayList();
            }
            this.apis.add(api);
            return this;
        }

        public RevolverHttpsServiceConfigBuilder apis(Collection<? extends RevolverHttpApiConfig> apis) {
            if (this.apis == null) {
                this.apis = new ArrayList();
            }
            this.apis.addAll(apis);
            return this;
        }

        public RevolverHttpsServiceConfigBuilder clearApis() {
            if (this.apis != null) {
                this.apis.clear();
            }
            return this;
        }

        public RevolverHttpsServiceConfigBuilder trackingHeaders(boolean trackingHeaders) {
            this.trackingHeaders = trackingHeaders;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder compression(boolean compression) {
            this.compression = compression;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder connectionKeepAliveInMillis(int connectionKeepAliveInMillis) {
            this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder threadPoolGroupConfig(ThreadPoolGroupConfig threadPoolGroupConfig) {
            this.threadPoolGroupConfig = threadPoolGroupConfig;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder actors(Map<String, ActorConfig> actors) {
            this.actors = actors;
            return this;
        }

        public RevolverHttpsServiceConfig build() {
            Set<Object> apis;
            switch (this.apis == null ? 0 : this.apis.size()) {
                case 0: {
                    apis = Collections.emptySet();
                    break;
                }
                case 1: {
                    apis = Collections.singleton(this.apis.get(0));
                    break;
                }
                default: {
                    apis = new LinkedHashSet(this.apis.size() < 0x40000000 ? 1 + this.apis.size() + (this.apis.size() - 3) / 3 : Integer.MAX_VALUE);
                    apis.addAll(this.apis);
                    apis = Collections.unmodifiableSet(apis);
                }
            }
            return new RevolverHttpsServiceConfig(this.type, this.service, this.enpoint, this.connectionPoolSize, this.authEnabled, this.auth, this.keyStorePath, this.keystorePassword, apis, this.trackingHeaders, this.compression, this.connectionKeepAliveInMillis, this.threadPoolGroupConfig, this.actors);
        }

        public String toString() {
            return "RevolverHttpsServiceConfig.RevolverHttpsServiceConfigBuilder(type=" + this.type + ", service=" + this.service + ", enpoint=" + this.enpoint + ", connectionPoolSize=" + this.connectionPoolSize + ", authEnabled=" + this.authEnabled + ", auth=" + this.auth + ", keyStorePath=" + this.keyStorePath + ", keystorePassword=" + this.keystorePassword + ", apis=" + this.apis + ", trackingHeaders=" + this.trackingHeaders + ", compression=" + this.compression + ", connectionKeepAliveInMillis=" + this.connectionKeepAliveInMillis + ", threadPoolGroupConfig=" + this.threadPoolGroupConfig + ", actors=" + this.actors + ")";
        }
    }
}

