/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http;

import com.codahale.metrics.MetricRegistry;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.raskasa.metrics.okhttp.InstrumentedOkHttpClients;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.http.auth.BasicAuthConfig;
import io.dropwizard.revolver.http.auth.TokenAuthConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okhttp3.internal.tls.OkHostnameVerifier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RevolverHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(RevolverHttpClientFactory.class);
    private static final LoadingCache<RevolverHttpServiceConfig, OkHttpClient> clientCache = Caffeine.newBuilder().build(RevolverHttpClientFactory::getOkHttpClient);

    RevolverHttpClientFactory() {
    }

    static OkHttpClient buildClient(RevolverHttpServiceConfig serviceConfiguration) {
        Preconditions.checkNotNull((Object)serviceConfiguration);
        return (OkHttpClient)clientCache.get((Object)serviceConfiguration);
    }

    private static OkHttpClient getOkHttpClient(RevolverHttpServiceConfig serviceConfiguration) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException, UnrecoverableKeyException {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.followRedirects(false);
        builder.followSslRedirects(false);
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequestsPerHost(serviceConfiguration.getConnectionPoolSize());
        dispatcher.setMaxRequests(serviceConfiguration.getConnectionPoolSize());
        builder.retryOnConnectionFailure(true);
        builder.connectTimeout(0L, TimeUnit.MILLISECONDS);
        builder.readTimeout(0L, TimeUnit.MILLISECONDS);
        builder.writeTimeout(0L, TimeUnit.MILLISECONDS);
        builder.dispatcher(dispatcher);
        if (serviceConfiguration.isAuthEnabled()) {
            switch (serviceConfiguration.getAuth().getType().toLowerCase()) {
                case "basic": {
                    BasicAuthConfig basicAuthConfig = (BasicAuthConfig)serviceConfiguration.getAuth();
                    if (!Strings.isNullOrEmpty((String)basicAuthConfig.getUsername())) {
                        throw new RuntimeException(String.format("No valid authentication data for service %s", serviceConfiguration.getAuth().getType()));
                    }
                    builder.authenticator((route, response) -> {
                        String credentials = Credentials.basic((String)basicAuthConfig.getUsername(), (String)basicAuthConfig.getPassword());
                        return response.request().newBuilder().addHeader("Authorization", credentials).build();
                    });
                    break;
                }
                case "token": {
                    TokenAuthConfig tokenAuthConfig = (TokenAuthConfig)serviceConfiguration.getAuth();
                    if (Strings.isNullOrEmpty((String)tokenAuthConfig.getPrefix())) {
                        builder.authenticator((route, response) -> response.request().newBuilder().addHeader("Authorization", tokenAuthConfig.getToken()).build());
                        break;
                    }
                    builder.authenticator((route, response) -> response.request().newBuilder().addHeader("Authorization", String.format("%s %s", tokenAuthConfig.getPrefix(), tokenAuthConfig.getToken())).build());
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Authentication type %s is not supported", serviceConfiguration.getAuth().getType()));
                }
            }
        }
        if (serviceConfiguration.isSecured()) {
            String keystorePassword;
            ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledTlsVersions().allEnabledCipherSuites().build();
            builder.connectionSpecs(Collections.singletonList(spec));
            String keystorePath = serviceConfiguration.getKeyStorePath();
            String string = keystorePassword = serviceConfiguration.getKeystorePassword() == null ? "" : serviceConfiguration.getKeystorePassword();
            if (!StringUtils.isBlank((CharSequence)keystorePath)) {
                RevolverHttpClientFactory.setSSLContext(keystorePath, keystorePassword, builder);
                builder.hostnameVerifier((HostnameVerifier)OkHostnameVerifier.INSTANCE);
            } else {
                HostnameVerifier hostNameVerifier = (s, sslSession) -> true;
                builder.hostnameVerifier(hostNameVerifier);
            }
        }
        if (serviceConfiguration.getConnectionKeepAliveInMillis() <= 0) {
            builder.connectionPool(new ConnectionPool(serviceConfiguration.getConnectionPoolSize(), 30L, TimeUnit.SECONDS));
        } else {
            builder.connectionPool(new ConnectionPool(serviceConfiguration.getConnectionPoolSize(), (long)serviceConfiguration.getConnectionKeepAliveInMillis(), TimeUnit.MILLISECONDS));
        }
        return InstrumentedOkHttpClients.create((MetricRegistry)RevolverBundle.getMetricRegistry(), (OkHttpClient)builder.build(), (String)serviceConfiguration.getService());
    }

    private static void setSSLContext(String keyStorePath, String keyStorePassword, OkHttpClient.Builder builder) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream instream = RevolverHttpClientFactory.class.getClassLoader().getResourceAsStream(keyStorePath);){
            keyStore.load(instream, keyStorePassword.toCharArray());
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        X509TrustManager trustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
    }
}

