package io.dropwizard.revolver.http;


import io.dropwizard.revolver.http.config.IdleConnectionConfig;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.conn.HttpClientConnectionManager;

import java.util.concurrent.TimeUnit;

/***
 Created by nitish.goyal on 12/02/19
 ***/
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Slf4j
public class IdleConnectionMonitorThread extends Thread {
    private HttpClientConnectionManager connMgr;
    private volatile boolean shutdown;
    private IdleConnectionConfig idleConnectionConfig;


    @Override
    public void run() {
        try {
            while (!shutdown) {
                synchronized (this) {
                    wait(idleConnectionConfig.getWaitTimeInMillis());
                    log.info("Closing ExpiredAndIdle connections");
                    connMgr.closeExpiredConnections();
                    connMgr.closeIdleConnections(idleConnectionConfig.getConnectionCloseTimeInSeconds(), TimeUnit.SECONDS);
                }
            }
        } catch (InterruptedException ex) {
            shutdown();
        }
    }

    public void shutdown() {
        shutdown = true;
        synchronized (this) {
            notifyAll();
        }
    }
}
