/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class IdleConnectionMonitorThread
extends Thread {
    private final HttpClientConnectionManager connMgr;
    private volatile boolean shutdown;

    public IdleConnectionMonitorThread(PoolingHttpClientConnectionManager connMgr) {
        this.connMgr = connMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    this.wait(1000L);
                    this.connMgr.closeExpiredConnections();
                    this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                }
            }
            return;
        }
        catch (InterruptedException ex) {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        IdleConnectionMonitorThread idleConnectionMonitorThread = this;
        synchronized (idleConnectionMonitorThread) {
            this.notifyAll();
        }
    }
}

