/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http.config;

import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.HystrixCommandConfig;
import io.dropwizard.revolver.http.config.RevolverHttpAuthorizationConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class RevolverHttpApiConfig
extends CommandHandlerConfig {
    @NotNull
    @NotEmpty
    private String path;
    private boolean async = false;
    private boolean whitelist = false;
    private String acceptType = "application/json";
    private String acceptEncoding = "identity";
    @NotNull
    @NotEmpty
    private Set<RequestMethod> methods = Collections.singleton(RequestMethod.GET);
    private Set<Integer> acceptableResponseCodes = Collections.emptySet();
    private Set<RevolverHttpAuthorizationConfig> authorizations;
    private RevolverHttpAuthorizationConfig authorization;
    private String callbackQueueId;

    public RevolverHttpApiConfig(String api, HystrixCommandConfig runtime, String path, Set<RequestMethod> methods, Set<Integer> acceptableResponseCodes, boolean sharedPool) {
        super(api, sharedPool, runtime);
        this.path = path;
        this.methods = methods;
        this.acceptableResponseCodes = acceptableResponseCodes;
    }

    public static RevolverHttpApiConfigBuilder configBuilder() {
        return new RevolverHttpApiConfigBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverHttpApiConfig)) {
            return false;
        }
        RevolverHttpApiConfig other = (RevolverHttpApiConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        if (this.isAsync() != other.isAsync()) {
            return false;
        }
        if (this.isWhitelist() != other.isWhitelist()) {
            return false;
        }
        String this$acceptType = this.getAcceptType();
        String other$acceptType = other.getAcceptType();
        if (this$acceptType == null ? other$acceptType != null : !this$acceptType.equals(other$acceptType)) {
            return false;
        }
        String this$acceptEncoding = this.getAcceptEncoding();
        String other$acceptEncoding = other.getAcceptEncoding();
        if (this$acceptEncoding == null ? other$acceptEncoding != null : !this$acceptEncoding.equals(other$acceptEncoding)) {
            return false;
        }
        Set<RequestMethod> this$methods = this.getMethods();
        Set<RequestMethod> other$methods = other.getMethods();
        if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
            return false;
        }
        Set<Integer> this$acceptableResponseCodes = this.getAcceptableResponseCodes();
        Set<Integer> other$acceptableResponseCodes = other.getAcceptableResponseCodes();
        if (this$acceptableResponseCodes == null ? other$acceptableResponseCodes != null : !((Object)this$acceptableResponseCodes).equals(other$acceptableResponseCodes)) {
            return false;
        }
        Set<RevolverHttpAuthorizationConfig> this$authorizations = this.getAuthorizations();
        Set<RevolverHttpAuthorizationConfig> other$authorizations = other.getAuthorizations();
        if (this$authorizations == null ? other$authorizations != null : !((Object)this$authorizations).equals(other$authorizations)) {
            return false;
        }
        RevolverHttpAuthorizationConfig this$authorization = this.getAuthorization();
        RevolverHttpAuthorizationConfig other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !((Object)this$authorization).equals(other$authorization)) {
            return false;
        }
        String this$callbackQueueId = this.getCallbackQueueId();
        String other$callbackQueueId = other.getCallbackQueueId();
        return !(this$callbackQueueId == null ? other$callbackQueueId != null : !this$callbackQueueId.equals(other$callbackQueueId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RevolverHttpApiConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        result = result * 59 + (this.isAsync() ? 79 : 97);
        result = result * 59 + (this.isWhitelist() ? 79 : 97);
        String $acceptType = this.getAcceptType();
        result = result * 59 + ($acceptType == null ? 43 : $acceptType.hashCode());
        String $acceptEncoding = this.getAcceptEncoding();
        result = result * 59 + ($acceptEncoding == null ? 43 : $acceptEncoding.hashCode());
        Set<RequestMethod> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        Set<Integer> $acceptableResponseCodes = this.getAcceptableResponseCodes();
        result = result * 59 + ($acceptableResponseCodes == null ? 43 : ((Object)$acceptableResponseCodes).hashCode());
        Set<RevolverHttpAuthorizationConfig> $authorizations = this.getAuthorizations();
        result = result * 59 + ($authorizations == null ? 43 : ((Object)$authorizations).hashCode());
        RevolverHttpAuthorizationConfig $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : ((Object)$authorization).hashCode());
        String $callbackQueueId = this.getCallbackQueueId();
        result = result * 59 + ($callbackQueueId == null ? 43 : $callbackQueueId.hashCode());
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isWhitelist() {
        return this.whitelist;
    }

    public String getAcceptType() {
        return this.acceptType;
    }

    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public Set<RequestMethod> getMethods() {
        return this.methods;
    }

    public Set<Integer> getAcceptableResponseCodes() {
        return this.acceptableResponseCodes;
    }

    public Set<RevolverHttpAuthorizationConfig> getAuthorizations() {
        return this.authorizations;
    }

    public RevolverHttpAuthorizationConfig getAuthorization() {
        return this.authorization;
    }

    public String getCallbackQueueId() {
        return this.callbackQueueId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setWhitelist(boolean whitelist) {
        this.whitelist = whitelist;
    }

    public void setAcceptType(String acceptType) {
        this.acceptType = acceptType;
    }

    public void setAcceptEncoding(String acceptEncoding) {
        this.acceptEncoding = acceptEncoding;
    }

    public void setMethods(Set<RequestMethod> methods) {
        this.methods = methods;
    }

    public void setAcceptableResponseCodes(Set<Integer> acceptableResponseCodes) {
        this.acceptableResponseCodes = acceptableResponseCodes;
    }

    public void setAuthorizations(Set<RevolverHttpAuthorizationConfig> authorizations) {
        this.authorizations = authorizations;
    }

    public void setAuthorization(RevolverHttpAuthorizationConfig authorization) {
        this.authorization = authorization;
    }

    public void setCallbackQueueId(String callbackQueueId) {
        this.callbackQueueId = callbackQueueId;
    }

    public RevolverHttpApiConfig(String path, boolean async, boolean whitelist, String acceptType, String acceptEncoding, Set<RequestMethod> methods, Set<Integer> acceptableResponseCodes, Set<RevolverHttpAuthorizationConfig> authorizations, RevolverHttpAuthorizationConfig authorization, String callbackQueueId) {
        this.path = path;
        this.async = async;
        this.whitelist = whitelist;
        this.acceptType = acceptType;
        this.acceptEncoding = acceptEncoding;
        this.methods = methods;
        this.acceptableResponseCodes = acceptableResponseCodes;
        this.authorizations = authorizations;
        this.authorization = authorization;
        this.callbackQueueId = callbackQueueId;
    }

    public RevolverHttpApiConfig() {
    }

    @Override
    public String toString() {
        return "RevolverHttpApiConfig(super=" + super.toString() + ", path=" + this.getPath() + ", async=" + this.isAsync() + ", whitelist=" + this.isWhitelist() + ", acceptType=" + this.getAcceptType() + ", acceptEncoding=" + this.getAcceptEncoding() + ", methods=" + this.getMethods() + ", acceptableResponseCodes=" + this.getAcceptableResponseCodes() + ", authorizations=" + this.getAuthorizations() + ", authorization=" + this.getAuthorization() + ", callbackQueueId=" + this.getCallbackQueueId() + ")";
    }

    public static class RevolverHttpApiConfigBuilder {
        private String api;
        private HystrixCommandConfig runtime;
        private String path;
        private ArrayList<RequestMethod> methods;
        private Set<Integer> acceptableResponseCodes;
        private boolean sharedPool;

        RevolverHttpApiConfigBuilder() {
        }

        public RevolverHttpApiConfigBuilder api(String api) {
            this.api = api;
            return this;
        }

        public RevolverHttpApiConfigBuilder runtime(HystrixCommandConfig runtime) {
            this.runtime = runtime;
            return this;
        }

        public RevolverHttpApiConfigBuilder path(String path) {
            this.path = path;
            return this;
        }

        public RevolverHttpApiConfigBuilder method(RequestMethod method) {
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.add(method);
            return this;
        }

        public RevolverHttpApiConfigBuilder methods(Collection<? extends RequestMethod> methods) {
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.addAll(methods);
            return this;
        }

        public RevolverHttpApiConfigBuilder clearMethods() {
            if (this.methods != null) {
                this.methods.clear();
            }
            return this;
        }

        public RevolverHttpApiConfigBuilder acceptableResponseCodes(Set<Integer> acceptableResponseCodes) {
            this.acceptableResponseCodes = acceptableResponseCodes;
            return this;
        }

        public RevolverHttpApiConfigBuilder sharedPool(boolean sharedPool) {
            this.sharedPool = sharedPool;
            return this;
        }

        public RevolverHttpApiConfig build() {
            Set<Object> methods;
            switch (this.methods == null ? 0 : this.methods.size()) {
                case 0: {
                    methods = Collections.emptySet();
                    break;
                }
                case 1: {
                    methods = Collections.singleton(this.methods.get(0));
                    break;
                }
                default: {
                    methods = new LinkedHashSet(this.methods.size() < 0x40000000 ? 1 + this.methods.size() + (this.methods.size() - 3) / 3 : Integer.MAX_VALUE);
                    methods.addAll(this.methods);
                    methods = Collections.unmodifiableSet(methods);
                }
            }
            return new RevolverHttpApiConfig(this.api, this.runtime, this.path, methods, this.acceptableResponseCodes, this.sharedPool);
        }

        public String toString() {
            return "RevolverHttpApiConfig.RevolverHttpApiConfigBuilder(api=" + this.api + ", runtime=" + this.runtime + ", path=" + this.path + ", methods=" + this.methods + ", acceptableResponseCodes=" + this.acceptableResponseCodes + ", sharedPool=" + this.sharedPool + ")";
        }
    }

    public static enum RequestMethod {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        PATCH,
        OPTIONS;

    }
}

