/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth;

import com.codahale.metrics.annotation.Metered;
import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenParser;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.TokenExpiredException;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.HmacSHA512Verifier;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import feign.FeignException;
import io.dropwizard.primer.cache.TokenCacheManager;
import io.dropwizard.primer.client.PrimerClient;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.core.ServiceUser;
import io.dropwizard.primer.core.VerifyResponse;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
public class PrimerAuthenticatorRequestFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(PrimerAuthenticatorRequestFilter.class);
    private JsonWebTokenParser tokenParser;
    private HmacSHA512Verifier verifier;
    private PrimerBundleConfiguration configuration;
    private final Duration acceptableClockSkew;
    private final PrimerClient primerClient;

    public PrimerAuthenticatorRequestFilter(JsonWebTokenParser tokenParser, HmacSHA512Verifier verifier, PrimerBundleConfiguration configuration, PrimerClient primerClient) {
        this.tokenParser = tokenParser;
        this.verifier = verifier;
        this.configuration = configuration;
        this.acceptableClockSkew = new Duration((long)configuration.getClockSkew());
        this.primerClient = primerClient;
    }

    @Metered
    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!this.configuration.isEnabled()) {
            return;
        }
        if (this.isWhilisted(requestContext.getUriInfo().getPath())) {
            return;
        }
        Optional<String> token = this.getToken(requestContext);
        if (!token.isPresent()) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)PrimerError.builder().errorCode("PR000").message("Bad request").build()).build());
        } else {
            try {
                if (TokenCacheManager.checkBlackList((String)token.get())) {
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)PrimerError.builder().errorCode("PR004").message("Forbidden").build()).build());
                }
                if (TokenCacheManager.checkCache((String)token.get())) {
                    return;
                }
            }
            catch (ExecutionException e) {
                log.warn("Error getting token from cache: {}", (Object)e.getMessage());
            }
            try {
                JsonWebToken webToken = this.verifyToken((String)token.get());
                this.checkExpiry(webToken);
                VerifyResponse verifyResponse = this.primerClient.verify(webToken.claim().issuer(), webToken.claim().subject(), (String)token.get(), ServiceUser.builder().id((String)webToken.claim().getParameter("user_id")).name((String)webToken.claim().getParameter("name")).role((String)webToken.claim().getParameter("role")).build());
                if (!StringUtils.isBlank((CharSequence)verifyResponse.getToken()) && !StringUtils.isBlank((CharSequence)verifyResponse.getUserId())) {
                    TokenCacheManager.cache((String)token.get());
                }
            }
            catch (TokenExpiredException e) {
                log.error("Token Expiry Error", (Throwable)e);
                requestContext.abortWith(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)PrimerError.builder().errorCode("PR003").message("Expired").build()).build());
            }
            catch (FeignException e) {
                log.error("Feign error", (Throwable)e);
                if (e.status() == 403) {
                    TokenCacheManager.blackList((String)token.get());
                }
                requestContext.abortWith(Response.status((int)e.status()).entity((Object)PrimerError.builder().errorCode("PR000").message("Error").build()).build());
            }
            catch (PrimerException e) {
                log.error("Primer error", (Throwable)e);
                if (e.getStatus() == Response.Status.FORBIDDEN.getStatusCode()) {
                    TokenCacheManager.blackList((String)token.get());
                }
                requestContext.abortWith(Response.status((int)e.getStatus()).entity((Object)PrimerError.builder().errorCode(e.getErrorCode()).message(e.getMessage()).build()).build());
            }
            catch (NullPointerException e) {
                log.error("Primer error", (Throwable)e);
                requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)PrimerError.builder().errorCode("PR002").message("Forbidden").build()).build());
            }
        }
    }

    private Optional<String> getToken(ContainerRequestContext requestContext) {
        String header = (String)requestContext.getHeaders().getFirst((Object)"Authorization");
        log.info("Authorization Header: {}", (Object)header);
        if (header != null) {
            String rawToken = header.replaceAll(this.configuration.getPrefix(), "").trim();
            if (Strings.isNullOrEmpty((String)rawToken)) {
                return Optional.absent();
            }
            return Optional.of((Object)rawToken);
        }
        return Optional.absent();
    }

    private JsonWebToken verifyToken(String rawToken) {
        JsonWebToken token = this.tokenParser.parse(rawToken);
        this.verifier.verifySignature(token);
        return token;
    }

    private void checkExpiry(JsonWebToken token) {
        if (token.claim() != null) {
            Instant now = new Instant();
            Instant issuedAt = (Instant)Optional.fromNullable((Object)this.toInstant(token.claim().issuedAt())).or((Object)now);
            Instant expiration = (Instant)Optional.fromNullable((Object)this.toInstant(token.claim().expiration())).or((Object)new Instant(Long.MAX_VALUE));
            Instant notBefore = (Instant)Optional.fromNullable((Object)this.toInstant(token.claim().notBefore())).or((Object)now);
            if (issuedAt.isAfter((ReadableInstant)expiration) || notBefore.isAfterNow() || !this.inInterval(issuedAt, expiration, now)) {
                throw new TokenExpiredException();
            }
        }
    }

    private boolean inInterval(Instant start, Instant end, Instant now) {
        Interval interval = new Interval((ReadableInstant)start, (ReadableInstant)end);
        Interval currentTimeWithSkew = new Interval((ReadableInstant)now.minus((ReadableDuration)this.acceptableClockSkew), (ReadableInstant)now.plus((ReadableDuration)this.acceptableClockSkew));
        return interval.overlaps((ReadableInterval)currentTimeWithSkew);
    }

    private Instant toInstant(Long input) {
        if (input == null) {
            return null;
        }
        return new Instant(input * 1000L);
    }

    private boolean isWhilisted(String path) {
        return this.configuration.getWhileListUrl().parallelStream().filter(path::startsWith).count() > 0L;
    }

    public static PrimerAuthenticatorRequestFilterBuilder builder() {
        return new PrimerAuthenticatorRequestFilterBuilder();
    }

    public static class PrimerAuthenticatorRequestFilterBuilder {
        private JsonWebTokenParser tokenParser;
        private HmacSHA512Verifier verifier;
        private PrimerBundleConfiguration configuration;
        private PrimerClient primerClient;

        PrimerAuthenticatorRequestFilterBuilder() {
        }

        public PrimerAuthenticatorRequestFilterBuilder tokenParser(JsonWebTokenParser tokenParser) {
            this.tokenParser = tokenParser;
            return this;
        }

        public PrimerAuthenticatorRequestFilterBuilder verifier(HmacSHA512Verifier verifier) {
            this.verifier = verifier;
            return this;
        }

        public PrimerAuthenticatorRequestFilterBuilder configuration(PrimerBundleConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public PrimerAuthenticatorRequestFilterBuilder primerClient(PrimerClient primerClient) {
            this.primerClient = primerClient;
            return this;
        }

        public PrimerAuthenticatorRequestFilter build() {
            return new PrimerAuthenticatorRequestFilter(this.tokenParser, this.verifier, this.configuration, this.primerClient);
        }

        public String toString() {
            return "PrimerAuthenticatorRequestFilter.PrimerAuthenticatorRequestFilterBuilder(tokenParser=" + this.tokenParser + ", verifier=" + this.verifier + ", configuration=" + this.configuration + ", primerClient=" + this.primerClient + ")";
        }
    }
}

