/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.model;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class PrimerBundleConfiguration {
    private String host;
    private int port;
    private int cacheExpiry;
    private int cacheMaxSize;
    private int clockSkew;
    private String prefix;
    private String privateKey;
    private boolean enabled = true;
    private Set<String> whileListUrl = new HashSet<String>();

    public static PrimerBundleConfigurationBuilder builder() {
        return new PrimerBundleConfigurationBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getCacheExpiry() {
        return this.cacheExpiry;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public int getClockSkew() {
        return this.clockSkew;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<String> getWhileListUrl() {
        return this.whileListUrl;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setCacheExpiry(int cacheExpiry) {
        this.cacheExpiry = cacheExpiry;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public void setClockSkew(int clockSkew) {
        this.clockSkew = clockSkew;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setWhileListUrl(Set<String> whileListUrl) {
        this.whileListUrl = whileListUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimerBundleConfiguration)) {
            return false;
        }
        PrimerBundleConfiguration other = (PrimerBundleConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getCacheExpiry() != other.getCacheExpiry()) {
            return false;
        }
        if (this.getCacheMaxSize() != other.getCacheMaxSize()) {
            return false;
        }
        if (this.getClockSkew() != other.getClockSkew()) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Set<String> this$whileListUrl = this.getWhileListUrl();
        Set<String> other$whileListUrl = other.getWhileListUrl();
        return !(this$whileListUrl == null ? other$whileListUrl != null : !((Object)this$whileListUrl).equals(other$whileListUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrimerBundleConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + this.getCacheExpiry();
        result = result * 59 + this.getCacheMaxSize();
        result = result * 59 + this.getClockSkew();
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Set<String> $whileListUrl = this.getWhileListUrl();
        result = result * 59 + ($whileListUrl == null ? 43 : ((Object)$whileListUrl).hashCode());
        return result;
    }

    public String toString() {
        return "PrimerBundleConfiguration(host=" + this.getHost() + ", port=" + this.getPort() + ", cacheExpiry=" + this.getCacheExpiry() + ", cacheMaxSize=" + this.getCacheMaxSize() + ", clockSkew=" + this.getClockSkew() + ", prefix=" + this.getPrefix() + ", privateKey=" + this.getPrivateKey() + ", enabled=" + this.isEnabled() + ", whileListUrl=" + this.getWhileListUrl() + ")";
    }

    @ConstructorProperties(value={"host", "port", "cacheExpiry", "cacheMaxSize", "clockSkew", "prefix", "privateKey", "enabled", "whileListUrl"})
    public PrimerBundleConfiguration(String host, int port, int cacheExpiry, int cacheMaxSize, int clockSkew, String prefix, String privateKey, boolean enabled, Set<String> whileListUrl) {
        this.host = host;
        this.port = port;
        this.cacheExpiry = cacheExpiry;
        this.cacheMaxSize = cacheMaxSize;
        this.clockSkew = clockSkew;
        this.prefix = prefix;
        this.privateKey = privateKey;
        this.enabled = enabled;
        this.whileListUrl = whileListUrl;
    }

    public PrimerBundleConfiguration() {
    }

    public static class PrimerBundleConfigurationBuilder {
        private String host;
        private int port;
        private int cacheExpiry;
        private int cacheMaxSize;
        private int clockSkew;
        private String prefix;
        private String privateKey;
        private boolean enabled;
        private ArrayList<String> whileListUrl;

        PrimerBundleConfigurationBuilder() {
        }

        public PrimerBundleConfigurationBuilder host(String host) {
            this.host = host;
            return this;
        }

        public PrimerBundleConfigurationBuilder port(int port) {
            this.port = port;
            return this;
        }

        public PrimerBundleConfigurationBuilder cacheExpiry(int cacheExpiry) {
            this.cacheExpiry = cacheExpiry;
            return this;
        }

        public PrimerBundleConfigurationBuilder cacheMaxSize(int cacheMaxSize) {
            this.cacheMaxSize = cacheMaxSize;
            return this;
        }

        public PrimerBundleConfigurationBuilder clockSkew(int clockSkew) {
            this.clockSkew = clockSkew;
            return this;
        }

        public PrimerBundleConfigurationBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public PrimerBundleConfigurationBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public PrimerBundleConfigurationBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public PrimerBundleConfigurationBuilder whiteList(String whiteList) {
            if (this.whileListUrl == null) {
                this.whileListUrl = new ArrayList();
            }
            this.whileListUrl.add(whiteList);
            return this;
        }

        public PrimerBundleConfigurationBuilder whileListUrl(Collection<? extends String> whileListUrl) {
            if (this.whileListUrl == null) {
                this.whileListUrl = new ArrayList();
            }
            this.whileListUrl.addAll(whileListUrl);
            return this;
        }

        public PrimerBundleConfiguration build() {
            Set<Object> whileListUrl;
            switch (this.whileListUrl == null ? 0 : this.whileListUrl.size()) {
                case 0: {
                    whileListUrl = Collections.emptySet();
                    break;
                }
                case 1: {
                    whileListUrl = Collections.singleton(this.whileListUrl.get(0));
                    break;
                }
                default: {
                    whileListUrl = new LinkedHashSet(this.whileListUrl.size() < 0x40000000 ? 1 + this.whileListUrl.size() + (this.whileListUrl.size() - 3) / 3 : Integer.MAX_VALUE);
                    whileListUrl.addAll(this.whileListUrl);
                    whileListUrl = Collections.unmodifiableSet(whileListUrl);
                }
            }
            return new PrimerBundleConfiguration(this.host, this.port, this.cacheExpiry, this.cacheMaxSize, this.clockSkew, this.prefix, this.privateKey, this.enabled, whileListUrl);
        }

        public String toString() {
            return "PrimerBundleConfiguration.PrimerBundleConfigurationBuilder(host=" + this.host + ", port=" + this.port + ", cacheExpiry=" + this.cacheExpiry + ", cacheMaxSize=" + this.cacheMaxSize + ", clockSkew=" + this.clockSkew + ", prefix=" + this.prefix + ", privateKey=" + this.privateKey + ", enabled=" + this.enabled + ", whileListUrl=" + this.whileListUrl + ")";
        }
    }
}

