/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.elasticsearch.managed;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Resources;
import io.dropwizard.elasticsearch.config.EsConfiguration;
import io.dropwizard.elasticsearch.util.TransportAddressHelper;
import io.dropwizard.lifecycle.Managed;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class ManagedEsClient
implements Managed {
    private Node node = null;
    private Client client = null;

    public ManagedEsClient(EsConfiguration config) {
        Preconditions.checkNotNull((Object)config, (Object)"EsConfiguration must not be null");
        Settings.Builder settingsBuilder = Settings.builder();
        if (!Strings.isNullOrEmpty((String)config.getSettingsFile())) {
            Path path = Paths.get(config.getSettingsFile(), new String[0]);
            if (!path.toFile().exists()) {
                try {
                    URL url = Resources.getResource((String)config.getSettingsFile());
                    path = new File(url.toURI()).toPath();
                }
                catch (NullPointerException | URISyntaxException e) {
                    throw new IllegalArgumentException("settings file cannot be found", e);
                }
            }
            settingsBuilder.loadFromPath(path);
        }
        Settings settings = settingsBuilder.put(config.getSettings()).put("cluster.name", config.getClusterName()).build();
        if (config.isNodeClient()) {
            this.node = NodeBuilder.nodeBuilder().client(true).data(false).settings(settings).build();
            this.client = this.node.client();
        } else {
            TransportAddress[] addresses = TransportAddressHelper.fromHostAndPorts(config.getServers());
            this.client = TransportClient.builder().settings(settings).build().addTransportAddresses(addresses);
        }
    }

    public ManagedEsClient(Node node) {
        this.node = (Node)Preconditions.checkNotNull((Object)node, (Object)"Elasticsearch node must not be null");
        this.client = node.client();
    }

    public ManagedEsClient(Client client) {
        this.client = (Client)Preconditions.checkNotNull((Object)client, (Object)"Elasticsearch client must not be null");
    }

    public void start() throws Exception {
        this.startNode();
    }

    public void stop() throws Exception {
        this.closeClient();
        this.closeNode();
    }

    public Client getClient() {
        return this.client;
    }

    private Node startNode() {
        if (null != this.node) {
            return this.node.start();
        }
        return null;
    }

    private void closeNode() {
        if (null != this.node && !this.node.isClosed()) {
            this.node.close();
        }
    }

    private void closeClient() {
        if (null != this.client) {
            this.client.close();
        }
    }
}

