/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.elasticsearch.health;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.client.Client;

public class EsClusterHealthCheck
extends HealthCheck {
    private final Client client;
    private final boolean failOnYellow;

    public EsClusterHealthCheck(Client client, boolean failOnYellow) {
        this.client = (Client)Preconditions.checkNotNull((Object)client);
        this.failOnYellow = failOnYellow;
    }

    public EsClusterHealthCheck(Client client) {
        this(client, false);
    }

    protected HealthCheck.Result check() throws Exception {
        ClusterHealthStatus status = ((ClusterHealthResponse)this.client.admin().cluster().prepareHealth(new String[0]).get()).getStatus();
        if (status == ClusterHealthStatus.RED || this.failOnYellow && status == ClusterHealthStatus.YELLOW) {
            return HealthCheck.Result.unhealthy((String)"Last status: %s", (Object[])new Object[]{status.name()});
        }
        return HealthCheck.Result.healthy((String)"Last status: %s", (Object[])new Object[]{status.name()});
    }
}

