/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.maxmind.geoip2.provider;

import com.google.common.base.Strings;
import io.dropwizard.maxmind.geoip2.core.MaxMindInfo;
import io.dropwizard.maxmind.geoip2.provider.MaxMindContext;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Provider
public class MaxMindInfoProvider
extends AbstractValueFactoryProvider {
    private static final Logger log = LoggerFactory.getLogger(MaxMindInfoProvider.class);

    @Inject
    public MaxMindInfoProvider(MultivaluedParameterExtractorProvider extractorProvider, ServiceLocator locator) {
        super(extractorProvider, locator, new Parameter.Source[]{Parameter.Source.UNKNOWN});
    }

    protected AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
        Class classType = parameter.getRawType();
        if (classType == null || !classType.equals(MaxMindInfo.class)) {
            log.warn("MaxMindContext annotation was not placed on correct object type; Injection might not work correctly!");
            return null;
        }
        return new MaxMinfInfoParamValueFactory();
    }

    private static final class MaxMinfInfoParamValueFactory
    extends AbstractContainerRequestValueFactory<MaxMindInfo> {
        @Context
        private ResourceContext context;

        private MaxMinfInfoParamValueFactory() {
        }

        public MaxMindInfo provide() {
            HttpServletRequest request = (HttpServletRequest)this.context.getResource(HttpServletRequest.class);
            String anonymousIp = request.getHeader("X-MAXMIND-REQUEST-ANONYMOUS-IP");
            String anonymousVpn = request.getHeader("X-MAXMIND-REQUEST-ANONYMOUS-VPN");
            String legalProxy = request.getHeader("X-MAXMIND-REQUEST-LEGAL-PROXY");
            String tor = request.getHeader("X-MAXMIND-REQUEST-TOR-NODE");
            String city = request.getHeader("X-MAXMIND-REQUEST-CITY");
            String state = request.getHeader("X-MAXMIND-REQUEST-STATE");
            String postal = request.getHeader("X-MAXMIND-REQUEST-POSTAL-CODE");
            String connectionType = request.getHeader("X-MAXMIND-REQUEST-CONNECTION-TYPE");
            String userType = request.getHeader("X-MAXMIND-REQUEST-USER-TYPE");
            String country = request.getHeader("X-MAXMIND-REQUEST-COUNTRY");
            String isp = request.getHeader("X-MAXMIND-REQUEST-ISP");
            String latitude = request.getHeader("X-MAXMIND-REQUEST-LATITUDE");
            String longitude = request.getHeader("X-MAXMIND-REQUEST-LONGITUDE");
            String accuracy = request.getHeader("X-MAXMIND-REQUEST-LOCATION-ACCURACY");
            return MaxMindInfo.builder().anonymousIp(Strings.isNullOrEmpty((String)anonymousIp) ? false : Boolean.valueOf(anonymousIp)).anonymousVpn(Strings.isNullOrEmpty((String)anonymousVpn) ? false : Boolean.valueOf(anonymousVpn)).tor(Strings.isNullOrEmpty((String)tor) ? false : Boolean.valueOf(tor)).legalProxy(Strings.isNullOrEmpty((String)legalProxy) ? false : Boolean.valueOf(legalProxy)).city(Strings.isNullOrEmpty((String)city) ? "UNKNOWN" : city).state(Strings.isNullOrEmpty((String)state) ? "UNKNOWN" : state).country(Strings.isNullOrEmpty((String)country) ? "UNKNOWN" : country).postal(Strings.isNullOrEmpty((String)postal) ? "UNKNOWN" : postal).connectionType(Strings.isNullOrEmpty((String)connectionType) ? "UNKNOWN" : connectionType).userType(Strings.isNullOrEmpty((String)userType) ? "UNKNOWN" : userType).isp(Strings.isNullOrEmpty((String)isp) ? "UNKNOWN" : isp).latitude(Strings.isNullOrEmpty((String)latitude) ? 0.0 : Double.valueOf(latitude)).longitude(Strings.isNullOrEmpty((String)longitude) ? 0.0 : Double.valueOf(longitude)).accuracy(Strings.isNullOrEmpty((String)accuracy) ? 0 : Integer.valueOf(accuracy)).build();
        }
    }

    public static final class InjectResolver
    extends ParamInjectionResolver<MaxMindContext> {
        public InjectResolver() {
            super(MaxMindInfoProvider.class);
        }
    }
}

