/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.maxmind.geoip2.filter;

import com.google.common.base.Strings;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.EnterpriseResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.Subdivision;
import com.maxmind.geoip2.record.Traits;
import io.dropwizard.maxmind.geoip2.cache.MaxMindCache;
import io.dropwizard.maxmind.geoip2.config.MaxMindConfig;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=3000)
public class MaxMindGeoIpRequestFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(MaxMindGeoIpRequestFilter.class);
    private final MaxMindConfig config;
    private DatabaseReader databaseReader;

    public MaxMindGeoIpRequestFilter(MaxMindConfig config) {
        this.config = config;
        try {
            this.databaseReader = new DatabaseReader.Builder(new File(config.getDatabaseFilePath())).withCache((NodeCache)new MaxMindCache(config)).build();
        }
        catch (IOException e) {
            log.error("Error initializing GeoIP database", (Throwable)e);
        }
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        String clientIp = (String)containerRequestContext.getHeaders().getFirst((Object)this.config.getRemoteIpHeader());
        if (!Strings.isNullOrEmpty((String)clientIp)) {
            InetAddress address;
            try {
                address = InetAddress.getByName(clientIp);
            }
            catch (Exception e) {
                log.warn("Cannot resolve address: {} | Error: {}", (Object)clientIp, (Object)e.getMessage());
                return;
            }
            if (this.config.isEnterprise() && address != null) {
                try {
                    AnonymousIpResponse anonymousIpResponse;
                    EnterpriseResponse enterpriseResponse = this.databaseReader.enterprise(address);
                    if (enterpriseResponse.getCountry() != null) {
                        this.addCountryInfo(enterpriseResponse.getCountry(), containerRequestContext);
                    }
                    if (enterpriseResponse.getMostSpecificSubdivision() != null) {
                        this.addStateInfo(enterpriseResponse.getMostSpecificSubdivision(), containerRequestContext);
                    }
                    if (enterpriseResponse.getCity() != null) {
                        this.addCityInfo(enterpriseResponse.getCity(), containerRequestContext);
                    }
                    if (enterpriseResponse.getPostal() != null) {
                        this.addPostalInfo(enterpriseResponse.getPostal(), containerRequestContext);
                    }
                    if (enterpriseResponse.getLocation() != null) {
                        this.addLocationInfo(enterpriseResponse.getLocation(), containerRequestContext);
                    }
                    if (enterpriseResponse.getTraits() != null) {
                        this.addTraitsInfo(enterpriseResponse.getTraits(), containerRequestContext);
                    }
                    if ((anonymousIpResponse = this.databaseReader.anonymousIp(address)) != null) {
                        this.anonymousInfo(anonymousIpResponse, containerRequestContext);
                    }
                }
                catch (GeoIp2Exception e) {
                    log.warn("Cannot resolve geoip info", (Throwable)e);
                }
            } else {
                switch (this.config.getType()) {
                    case "country": {
                        try {
                            CountryResponse countryResponse = this.databaseReader.country(address);
                            this.addCountryInfo(countryResponse.getCountry(), containerRequestContext);
                        }
                        catch (GeoIp2Exception e) {
                            log.warn("Error adding country info", (Throwable)e);
                        }
                        break;
                    }
                    case "city": {
                        try {
                            CityResponse cityResponse = this.databaseReader.city(address);
                            this.addCountryInfo(cityResponse.getCountry(), containerRequestContext);
                            this.addStateInfo(cityResponse.getMostSpecificSubdivision(), containerRequestContext);
                            this.addCityInfo(cityResponse.getCity(), containerRequestContext);
                        }
                        catch (GeoIp2Exception e) {
                            log.warn("Error adding city info", (Throwable)e);
                        }
                        break;
                    }
                    case "anonymous": {
                        try {
                            AnonymousIpResponse anonymousIpResponse = this.databaseReader.anonymousIp(address);
                            this.anonymousInfo(anonymousIpResponse, containerRequestContext);
                            break;
                        }
                        catch (GeoIp2Exception e) {
                            log.warn("Error adding city info", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private void addCountryInfo(Country country, ContainerRequestContext containerRequestContext) {
        if (Strings.isNullOrEmpty((String)country.getName())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-COUNTRY", (Object)country.getName());
        }
    }

    private void addStateInfo(Subdivision subdivision, ContainerRequestContext containerRequestContext) {
        if (Strings.isNullOrEmpty((String)subdivision.getName())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-STATE", (Object)subdivision.getName());
        }
    }

    private void addCityInfo(City city, ContainerRequestContext containerRequestContext) {
        if (Strings.isNullOrEmpty((String)city.getName())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-CITY", (Object)city.getName());
        }
    }

    private void addPostalInfo(Postal postal, ContainerRequestContext containerRequestContext) {
        if (Strings.isNullOrEmpty((String)postal.getCode())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-POSTAL-CODE", (Object)postal.getCode());
        }
    }

    private void addLocationInfo(Location location, ContainerRequestContext containerRequestContext) {
        if (location.getLatitude() != null) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-LATITUDE", (Object)String.valueOf(location.getLatitude()));
        }
        if (location.getLongitude() != null) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-LONGITUDE", (Object)String.valueOf(location.getLongitude()));
        }
        if (location.getAccuracyRadius() != null) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-LOCATION-ACCURACY", (Object)String.valueOf(location.getAccuracyRadius()));
        }
    }

    private void addTraitsInfo(Traits traits, ContainerRequestContext containerRequestContext) {
        if (Strings.isNullOrEmpty((String)traits.getUserType())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-USER-TYPE", (Object)traits.getUserType());
        }
        if (traits.getConnectionType() != null) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-CONNECTION-TYPE", (Object)traits.getConnectionType().name());
        }
        if (Strings.isNullOrEmpty((String)traits.getIsp())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-ISP", (Object)traits.getIsp());
        }
        containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-LEGAL-PROXY", (Object)String.valueOf(traits.isLegitimateProxy()));
    }

    private void anonymousInfo(AnonymousIpResponse anonymousIpResponse, ContainerRequestContext containerRequestContext) {
        containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-ANONYMOUS-IP", (Object)String.valueOf(anonymousIpResponse.isAnonymous()));
        containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-ANONYMOUS-VPN", (Object)String.valueOf(anonymousIpResponse.isAnonymousVpn()));
        containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-TOR-NODE", (Object)String.valueOf(anonymousIpResponse.isTorExitNode()));
    }
}

