/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.rmq.healthcheck.healtcheck;

import com.codahale.metrics.health.HealthCheck;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RabbitHealthCheck
extends HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(RabbitHealthCheck.class);
    public Connection connection;
    private List<String> queues;

    public RabbitHealthCheck(Connection connection, List<String> queues) {
        this.connection = connection;
        this.queues = queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HealthCheck.Result check() throws Exception {
        if (this.connection == null) {
            return HealthCheck.Result.unhealthy((String)"No RMQ connection available");
        }
        if (!this.connection.isOpen()) {
            return HealthCheck.Result.unhealthy((String)"RMQ connection is not open");
        }
        if (this.queues != null && !this.queues.isEmpty()) {
            try (Channel channel = null;){
                channel = this.connection.createChannel();
                if (!channel.isOpen()) {
                    HealthCheck.Result result = HealthCheck.Result.unhealthy((String)"Cannot open channel with RabbitMQ");
                    return result;
                }
                boolean isOk = true;
                for (String q : this.queues) {
                    isOk = channel.consumerCount(q) > 0L;
                }
                if (!isOk) {
                    HealthCheck.Result result = HealthCheck.Result.unhealthy((String)"RMQ is having issues! Please attend to it now!");
                    return result;
                }
            }
        }
        return HealthCheck.Result.healthy();
    }

    public static RabbitHealthCheckBuilder builder() {
        return new RabbitHealthCheckBuilder();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public List<String> getQueues() {
        return this.queues;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setQueues(List<String> queues) {
        this.queues = queues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RabbitHealthCheck)) {
            return false;
        }
        RabbitHealthCheck other = (RabbitHealthCheck)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Connection this$connection = this.getConnection();
        Connection other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) {
            return false;
        }
        List<String> this$queues = this.getQueues();
        List<String> other$queues = other.getQueues();
        return !(this$queues == null ? other$queues != null : !((Object)this$queues).equals(other$queues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RabbitHealthCheck;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Connection $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
        List<String> $queues = this.getQueues();
        result = result * 59 + ($queues == null ? 43 : ((Object)$queues).hashCode());
        return result;
    }

    public String toString() {
        return "RabbitHealthCheck(connection=" + this.getConnection() + ", queues=" + this.getQueues() + ")";
    }

    public static class RabbitHealthCheckBuilder {
        private Connection connection;
        private ArrayList<String> queues;

        RabbitHealthCheckBuilder() {
        }

        public RabbitHealthCheckBuilder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        public RabbitHealthCheckBuilder queue(String queue) {
            if (this.queues == null) {
                this.queues = new ArrayList();
            }
            this.queues.add(queue);
            return this;
        }

        public RabbitHealthCheckBuilder queues(Collection<? extends String> queues) {
            if (this.queues == null) {
                this.queues = new ArrayList();
            }
            this.queues.addAll(queues);
            return this;
        }

        public RabbitHealthCheckBuilder clearQueues() {
            if (this.queues != null) {
                this.queues.clear();
            }
            return this;
        }

        public RabbitHealthCheck build() {
            List<String> queues;
            switch (this.queues == null ? 0 : this.queues.size()) {
                case 0: {
                    queues = Collections.emptyList();
                    break;
                }
                case 1: {
                    queues = Collections.singletonList(this.queues.get(0));
                    break;
                }
                default: {
                    queues = Collections.unmodifiableList(new ArrayList<String>(this.queues));
                }
            }
            return new RabbitHealthCheck(this.connection, queues);
        }

        public String toString() {
            return "RabbitHealthCheck.RabbitHealthCheckBuilder(connection=" + this.connection + ", queues=" + this.queues + ")";
        }
    }
}

