/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.resource;

import com.codahale.metrics.annotation.Metered;
import com.flipkart.ranger.healthcheck.HealthcheckStatus;
import com.flipkart.ranger.model.ServiceNode;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.model.RevolverApiMetadata;
import io.dropwizard.revolver.core.model.RevolverMetadataResponse;
import io.dropwizard.revolver.core.model.RevolverServiceMetadata;
import io.dropwizard.revolver.discovery.RevolverServiceResolver;
import io.dropwizard.revolver.discovery.model.RangerEndpointSpec;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.swagger.annotations.ApiOperation;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/revolver")
@Singleton
public class RevolverMetadataResource {
    private static final Logger log = LoggerFactory.getLogger(RevolverMetadataResource.class);
    public static final String UNKNOWN = "UNKNOWN";
    private RevolverConfig config;

    public RevolverMetadataResource(RevolverConfig config) {
        this.config = config;
    }

    @Path(value="/v1/metadata/status")
    @GET
    @Metered
    @ApiOperation(value="Get the status & metadata of revolver api gateway")
    @Produces(value={"application/json"})
    public RevolverMetadataResponse status() {
        RevolverMetadataResponse.RevolverMetadataResponseBuilder metadataResponse = RevolverMetadataResponse.builder();
        metadataResponse.clientId(this.config.getClientConfig().getClientName());
        List<RevolverHttpServiceConfig> services = this.config.getServices().stream().filter(service -> service instanceof RevolverHttpServiceConfig).map(service -> (RevolverHttpServiceConfig)service).sorted(Comparator.comparing(RevolverServiceConfig::getService)).collect(Collectors.toList());
        services.forEach(s -> {
            RevolverServiceMetadata.RevolverServiceMetadataBuilder serviceMetadataBuilder = RevolverServiceMetadata.builder();
            serviceMetadataBuilder.name(s.getService()).type(s.getType()).apis(this.apiMetadataList((RevolverHttpServiceConfig)s));
            if (s.getEndpoint() instanceof RangerEndpointSpec) {
                this.instanceStats((RangerEndpointSpec)s.getEndpoint(), serviceMetadataBuilder);
            } else {
                serviceMetadataBuilder.status(UNKNOWN);
            }
            metadataResponse.service(serviceMetadataBuilder.build());
        });
        return metadataResponse.build();
    }

    @Path(value="/v1/metadata/service/ranger/{service}")
    @GET
    @Metered
    @ApiOperation(value="Get the status & metadata of a service registered in api")
    @Produces(value={"application/json"})
    public List<ServiceNode<RevolverServiceResolver.ShardInfo>> serviceStatus(@PathParam(value="service") String service) {
        RevolverServiceResolver serviceResolver = RevolverBundle.getServiceNameResolver();
        RevolverServiceResolver.ShardedServiceDiscoveryInfo serviceInfo = serviceResolver.getServiceFinders().getOrDefault(service, null);
        if (serviceInfo == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return serviceInfo.getShardFinder().getAll((Object)new RevolverServiceResolver.ShardInfo(serviceInfo.getEnvironment()));
    }

    @Path(value="/v1/metadata/config")
    @GET
    @Metered
    @ApiOperation(value="Get configuration of revolver api gateway")
    @Produces(value={"application/json"})
    public RevolverConfig config() {
        return this.config;
    }

    @Path(value="/v1/metadata/config/threads")
    @GET
    @Metered
    @ApiOperation(value="Get threads provisioned on gateway")
    @Produces(value={"application/json"})
    public Response threads() {
        int apiThreads = 0;
        int sharedThreads = 0;
        for (RevolverServiceConfig s : this.config.getServices()) {
            if (!(s instanceof RevolverHttpServiceConfig)) continue;
            if (((RevolverHttpServiceConfig)s).getApis().stream().noneMatch(CommandHandlerConfig::isSharedPool)) {
                sharedThreads += s.getRuntime().getThreadPool().getConcurrency();
                continue;
            }
            Set<RevolverHttpApiConfig> apis = ((RevolverHttpServiceConfig)s).getApis();
            apiThreads += apis.stream().filter(a -> !a.isSharedPool()).mapToInt(a -> a.getRuntime().getThreadPool().getConcurrency()).sum();
        }
        return Response.ok((Object)ImmutableMap.builder().put((Object)"apiThreads", (Object)apiThreads).put((Object)"sharedThreads", (Object)sharedThreads).build()).build();
    }

    private List<RevolverApiMetadata> apiMetadataList(RevolverHttpServiceConfig httpServiceConfig) {
        return httpServiceConfig.getApis().parallelStream().map(a -> RevolverApiMetadata.builder().async(a.isAsync()).name(a.getApi()).path(a.getPath()).methods(a.getMethods()).secured(!a.isWhitelist()).build()).sorted(Comparator.comparing(RevolverApiMetadata::getPath)).collect(Collectors.toList());
    }

    private void instanceStats(RangerEndpointSpec endpoint, RevolverServiceMetadata.RevolverServiceMetadataBuilder serviceMetadataBuilder) {
        RevolverServiceResolver serviceResolver = RevolverBundle.getServiceNameResolver();
        if (serviceResolver == null) {
            serviceMetadataBuilder.status(UNKNOWN);
        } else if (serviceResolver.getServiceFinders().containsKey(endpoint.getService())) {
            List serviceNodes = serviceResolver.getServiceFinders().get(endpoint.getService()).getShardFinder().getAll((Object)new RevolverServiceResolver.ShardInfo(endpoint.getEnvironment()));
            long healthy = serviceNodes.parallelStream().filter(n -> n.getHealthcheckStatus() == HealthcheckStatus.healthy).count();
            serviceMetadataBuilder.instances(serviceNodes.size()).healthy(healthy).unhealthy((long)serviceNodes.size() - healthy);
            serviceMetadataBuilder.status(healthy > 0L ? "HEALTHY" : UNKNOWN);
        } else {
            serviceMetadataBuilder.status(UNKNOWN);
        }
    }

    public static RevolverMetadataResourceBuilder builder() {
        return new RevolverMetadataResourceBuilder();
    }

    public RevolverConfig getConfig() {
        return this.config;
    }

    public void setConfig(RevolverConfig config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverMetadataResource)) {
            return false;
        }
        RevolverMetadataResource other = (RevolverMetadataResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RevolverConfig this$config = this.getConfig();
        RevolverConfig other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverMetadataResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RevolverConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    public String toString() {
        return "RevolverMetadataResource(config=" + this.getConfig() + ")";
    }

    public static class RevolverMetadataResourceBuilder {
        private RevolverConfig config;

        RevolverMetadataResourceBuilder() {
        }

        public RevolverMetadataResourceBuilder config(RevolverConfig config) {
            this.config = config;
            return this;
        }

        public RevolverMetadataResource build() {
            return new RevolverMetadataResource(this.config);
        }

        public String toString() {
            return "RevolverMetadataResource.RevolverMetadataResourceBuilder(config=" + this.config + ")";
        }
    }
}

