/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class RevolverHttpAuthorizationConfig {
    private String namespace;
    private String type;
    private Set<String> methods;
    private Set<String> roles;
    private Set<String> permissions;

    private static String $default$type() {
        return "dynamic";
    }

    public static RevolverHttpAuthorizationConfigBuilder builder() {
        return new RevolverHttpAuthorizationConfigBuilder();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getMethods() {
        return this.methods;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMethods(Set<String> methods) {
        this.methods = methods;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverHttpAuthorizationConfig)) {
            return false;
        }
        RevolverHttpAuthorizationConfig other = (RevolverHttpAuthorizationConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Set<String> this$methods = this.getMethods();
        Set<String> other$methods = other.getMethods();
        if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
            return false;
        }
        Set<String> this$roles = this.getRoles();
        Set<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        Set<String> this$permissions = this.getPermissions();
        Set<String> other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverHttpAuthorizationConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Set<String> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        Set<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        Set<String> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }

    public String toString() {
        return "RevolverHttpAuthorizationConfig(namespace=" + this.getNamespace() + ", type=" + this.getType() + ", methods=" + this.getMethods() + ", roles=" + this.getRoles() + ", permissions=" + this.getPermissions() + ")";
    }

    public RevolverHttpAuthorizationConfig(String namespace, String type, Set<String> methods, Set<String> roles, Set<String> permissions) {
        this.namespace = namespace;
        this.type = type;
        this.methods = methods;
        this.roles = roles;
        this.permissions = permissions;
    }

    public RevolverHttpAuthorizationConfig() {
    }

    public static class RevolverHttpAuthorizationConfigBuilder {
        private String namespace;
        private boolean type$set;
        private String type;
        private ArrayList<String> methods;
        private ArrayList<String> roles;
        private ArrayList<String> permissions;

        RevolverHttpAuthorizationConfigBuilder() {
        }

        public RevolverHttpAuthorizationConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder type(String type) {
            this.type = type;
            this.type$set = true;
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder method(String method) {
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.add(method);
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder methods(Collection<? extends String> methods) {
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.addAll(methods);
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder clearMethods() {
            if (this.methods != null) {
                this.methods.clear();
            }
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder role(String role) {
            if (this.roles == null) {
                this.roles = new ArrayList();
            }
            this.roles.add(role);
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder roles(Collection<? extends String> roles) {
            if (this.roles == null) {
                this.roles = new ArrayList();
            }
            this.roles.addAll(roles);
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder clearRoles() {
            if (this.roles != null) {
                this.roles.clear();
            }
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder permission(String permission) {
            if (this.permissions == null) {
                this.permissions = new ArrayList();
            }
            this.permissions.add(permission);
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder permissions(Collection<? extends String> permissions) {
            if (this.permissions == null) {
                this.permissions = new ArrayList();
            }
            this.permissions.addAll(permissions);
            return this;
        }

        public RevolverHttpAuthorizationConfigBuilder clearPermissions() {
            if (this.permissions != null) {
                this.permissions.clear();
            }
            return this;
        }

        public RevolverHttpAuthorizationConfig build() {
            Set<Object> permissions;
            Set<Object> roles;
            Set<Object> methods;
            switch (this.methods == null ? 0 : this.methods.size()) {
                case 0: {
                    methods = Collections.emptySet();
                    break;
                }
                case 1: {
                    methods = Collections.singleton(this.methods.get(0));
                    break;
                }
                default: {
                    methods = new LinkedHashSet(this.methods.size() < 0x40000000 ? 1 + this.methods.size() + (this.methods.size() - 3) / 3 : Integer.MAX_VALUE);
                    methods.addAll(this.methods);
                    methods = Collections.unmodifiableSet(methods);
                }
            }
            switch (this.roles == null ? 0 : this.roles.size()) {
                case 0: {
                    roles = Collections.emptySet();
                    break;
                }
                case 1: {
                    roles = Collections.singleton(this.roles.get(0));
                    break;
                }
                default: {
                    roles = new LinkedHashSet(this.roles.size() < 0x40000000 ? 1 + this.roles.size() + (this.roles.size() - 3) / 3 : Integer.MAX_VALUE);
                    roles.addAll(this.roles);
                    roles = Collections.unmodifiableSet(roles);
                }
            }
            switch (this.permissions == null ? 0 : this.permissions.size()) {
                case 0: {
                    permissions = Collections.emptySet();
                    break;
                }
                case 1: {
                    permissions = Collections.singleton(this.permissions.get(0));
                    break;
                }
                default: {
                    permissions = new LinkedHashSet(this.permissions.size() < 0x40000000 ? 1 + this.permissions.size() + (this.permissions.size() - 3) / 3 : Integer.MAX_VALUE);
                    permissions.addAll(this.permissions);
                    permissions = Collections.unmodifiableSet(permissions);
                }
            }
            String type = this.type;
            if (!this.type$set) {
                type = RevolverHttpAuthorizationConfig.$default$type();
            }
            return new RevolverHttpAuthorizationConfig(this.namespace, type, methods, roles, permissions);
        }

        public String toString() {
            return "RevolverHttpAuthorizationConfig.RevolverHttpAuthorizationConfigBuilder(namespace=" + this.namespace + ", type=" + this.type + ", methods=" + this.methods + ", roles=" + this.roles + ", permissions=" + this.permissions + ")";
        }
    }
}

