/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.dropwizard.revolver.http.auth.BasicAuthConfig;
import io.dropwizard.revolver.http.auth.TokenAuthConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okhttp3.internal.tls.OkHostnameVerifier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(RevolverHttpClientFactory.class);
    private static Map<String, OkHttpClient> clientCache = new HashMap<String, OkHttpClient>();

    public static synchronized void initClient(RevolverHttpServiceConfig serviceConfiguration) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        Preconditions.checkNotNull((Object)serviceConfiguration);
        clientCache.put(serviceConfiguration.getService(), RevolverHttpClientFactory.getOkHttpClient(serviceConfiguration));
    }

    static OkHttpClient client(RevolverHttpServiceConfig serviceConfiguration) {
        return clientCache.getOrDefault(serviceConfiguration.getService(), null);
    }

    private static OkHttpClient getOkHttpClient(RevolverHttpServiceConfig serviceConfiguration) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException, UnrecoverableKeyException {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(serviceConfiguration.getConnectionPoolSize());
        dispatcher.setMaxRequestsPerHost(serviceConfiguration.getConnectionPoolSize());
        OkHttpClient.Builder builder = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectTimeout(Integer.MAX_VALUE, TimeUnit.MILLISECONDS).readTimeout(Integer.MAX_VALUE, TimeUnit.MILLISECONDS).writeTimeout(Integer.MAX_VALUE, TimeUnit.MILLISECONDS).connectTimeout(Integer.MAX_VALUE, TimeUnit.MILLISECONDS).followRedirects(false).followSslRedirects(false).connectionPool(new ConnectionPool(serviceConfiguration.getConnectionPoolSize(), serviceConfiguration.getConnectionKeepAliveInMillis() <= 0 ? 30000L : (long)serviceConfiguration.getConnectionKeepAliveInMillis(), TimeUnit.MILLISECONDS)).dispatcher(dispatcher);
        if (serviceConfiguration.isAuthEnabled()) {
            switch (serviceConfiguration.getAuth().getType().toLowerCase()) {
                case "basic": {
                    BasicAuthConfig basicAuthConfig = (BasicAuthConfig)serviceConfiguration.getAuth();
                    if (!Strings.isNullOrEmpty((String)basicAuthConfig.getUsername())) {
                        throw new RuntimeException(String.format("No valid authentication data for service %s", serviceConfiguration.getAuth().getType()));
                    }
                    builder.authenticator((route, response) -> {
                        String credentials = Credentials.basic((String)basicAuthConfig.getUsername(), (String)basicAuthConfig.getPassword());
                        return response.request().newBuilder().addHeader("Authorization", credentials).build();
                    });
                    break;
                }
                case "token": {
                    TokenAuthConfig tokenAuthConfig = (TokenAuthConfig)serviceConfiguration.getAuth();
                    if (Strings.isNullOrEmpty((String)tokenAuthConfig.getPrefix())) {
                        builder.authenticator((route, response) -> response.request().newBuilder().addHeader("Authorization", tokenAuthConfig.getToken()).build());
                        break;
                    }
                    builder.authenticator((route, response) -> response.request().newBuilder().addHeader("Authorization", String.format("%s %s", tokenAuthConfig.getPrefix(), tokenAuthConfig.getToken())).build());
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Authentication type %s is not supported", serviceConfiguration.getAuth().getType()));
                }
            }
        }
        if (serviceConfiguration.isSecured()) {
            String keystorePassword;
            ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledTlsVersions().allEnabledCipherSuites().build();
            builder.connectionSpecs(Collections.singletonList(spec));
            String keystorePath = serviceConfiguration.getKeyStorePath();
            String string = keystorePassword = serviceConfiguration.getKeystorePassword() == null ? "" : serviceConfiguration.getKeystorePassword();
            if (!StringUtils.isBlank((CharSequence)keystorePath)) {
                RevolverHttpClientFactory.configureSSL(keystorePath, keystorePassword, builder);
            } else {
                HostnameVerifier hostNameVerifier = (s, sslSession) -> true;
                builder.hostnameVerifier(hostNameVerifier);
            }
        }
        return builder.build();
    }

    private static void configureSSL(String keyStorePath, String keyStorePassword, OkHttpClient.Builder clientBuilder) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream instream = RevolverHttpClientFactory.class.getClassLoader().getResourceAsStream(keyStorePath);){
            keyStore.load(instream, keyStorePassword.toCharArray());
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        clientBuilder.hostnameVerifier((HostnameVerifier)OkHostnameVerifier.INSTANCE);
        clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagerFactory.getTrustManagers()[0]);
    }
}

