/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.handler;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.config.RevolverConfig;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigHandler
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigHandler.class);
    private RevolverConfig revolverConfig;
    private ScheduledExecutorService scheduledExecutorService;
    private ObjectMapper objectMapper;
    private String configAttribute;
    private String prevConfigHash;
    private long prevLoadTime;

    public DynamicConfigHandler(String configAttribute, RevolverConfig revolverConfig, ObjectMapper objectMapper) {
        this.configAttribute = configAttribute;
        this.revolverConfig = revolverConfig;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.objectMapper = objectMapper.copy();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            this.prevConfigHash = this.computeHash(this.loadConfigData());
            log.info("Initializing dynamic config handler... Config Hash: {}", (Object)this.prevConfigHash);
        }
        catch (Exception e) {
            log.error("Error fetching configuration", (Throwable)e);
        }
    }

    public void start() {
        this.scheduledExecutorService.scheduleWithFixedDelay(this::refreshConfig, 120L, this.revolverConfig.getConfigPollIntervalSeconds(), TimeUnit.SECONDS);
    }

    public String refreshConfig() {
        try {
            String substituted = this.loadConfigData();
            String curHash = this.computeHash(substituted);
            log.info("Old Config Hash: {} | New Config Hash: {}", (Object)this.prevConfigHash, (Object)curHash);
            if (!this.prevConfigHash.equals(curHash)) {
                log.info("Refreshing config with new hash: {}", (Object)curHash);
                RevolverConfig revolverConfig = (RevolverConfig)this.objectMapper.readValue(substituted, RevolverConfig.class);
                RevolverBundle.loadServiceConfiguration(revolverConfig);
                this.prevConfigHash = curHash;
                this.prevLoadTime = System.currentTimeMillis();
                return this.prevConfigHash;
            }
            log.info("No config changes detected. Not reloading config..");
            return this.prevConfigHash;
        }
        catch (Exception e) {
            log.error("Error fetching configuration", (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> configLoadInfo() {
        return ImmutableMap.builder().put((Object)"hash", (Object)this.prevConfigHash).put((Object)"loadTime", (Object)new Date(this.prevLoadTime)).build();
    }

    private String loadConfigData() throws Exception {
        log.info("Fetching configuration from dynamic url: {}", (Object)this.revolverConfig.getDynamicConfigUrl());
        JsonNode node = (JsonNode)this.objectMapper.readTree((JsonParser)new YAMLFactory().createParser(new URL(this.revolverConfig.getDynamicConfigUrl())));
        EnvironmentVariableSubstitutor substitute = new EnvironmentVariableSubstitutor(false, true);
        return substitute.replace(node.get(this.configAttribute).toString());
    }

    private String computeHash(String config) {
        return Hashing.sha256().hashString((CharSequence)config, Charsets.UTF_8).toString();
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
    }
}

