/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.handler;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.config.RevolverConfig;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigHandler
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigHandler.class);
    private RevolverConfig revolverConfig;
    private ScheduledExecutorService scheduledExecutorService;
    private ObjectMapper objectMapper;
    private String configAttribute;

    public DynamicConfigHandler(String configAttribute, RevolverConfig revolverConfig, ObjectMapper objectMapper) {
        this.configAttribute = configAttribute;
        this.revolverConfig = revolverConfig;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.objectMapper = objectMapper.copy();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void start() {
        this.scheduledExecutorService.scheduleWithFixedDelay(this::refreshConfig, 120L, this.revolverConfig.getConfigPollIntervalSeconds(), TimeUnit.SECONDS);
    }

    private void refreshConfig() {
        try {
            log.info("Fetching configuration from dynamic url: {}", (Object)this.revolverConfig.getDynamicConfigUrl());
            JsonNode node = (JsonNode)this.objectMapper.readTree((JsonParser)new YAMLFactory().createParser(new URL(this.revolverConfig.getDynamicConfigUrl())));
            EnvironmentVariableSubstitutor substitute = new EnvironmentVariableSubstitutor(false, true);
            String substituted = substitute.replace(node.get(this.configAttribute).toString());
            RevolverConfig revolverConfig = (RevolverConfig)this.objectMapper.readValue(substituted, RevolverConfig.class);
            RevolverBundle.loadServiceConfiguration(revolverConfig);
        }
        catch (Exception e) {
            log.error("Error fetching configuration", (Throwable)e);
        }
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
    }
}

