/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.handler;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import io.dropwizard.Configuration;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.config.RevolverConfig;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicConfigHandler<T extends Configuration>
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigHandler.class);
    private RevolverConfig revolverConfig;
    private Class<T> configClass;
    private ScheduledExecutorService scheduledExecutorService;
    private ObjectMapper objectMapper;

    protected abstract RevolverConfig getRevolverConfig(T var1);

    public DynamicConfigHandler(Class<T> configClass, RevolverConfig revolverConfig, ObjectMapper objectMapper) {
        this.configClass = configClass;
        this.revolverConfig = revolverConfig;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.objectMapper = objectMapper.copy();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void start() {
        this.scheduledExecutorService.scheduleWithFixedDelay(this::refreshConfig, 120L, this.revolverConfig.getConfigPollIntervalSeconds(), TimeUnit.SECONDS);
    }

    private void refreshConfig() {
        try {
            log.info("Fetching configuration from dynamic url: {}", (Object)this.revolverConfig.getDynamicConfigUrl());
            JsonNode node = this.objectMapper.readTree(new URL(this.revolverConfig.getDynamicConfigUrl()));
            Configuration config = (Configuration)this.objectMapper.readValue((JsonParser)new TreeTraversingParser(node), this.configClass);
            RevolverBundle.loadServiceConfiguration(this.getRevolverConfig(config));
        }
        catch (Exception e) {
            log.error("Error fetching configuration", (Throwable)e);
        }
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
    }
}

