/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.handler;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.config.RevolverConfig;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicConfigHandler<T>
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigHandler.class);
    private RevolverConfig revolverConfig;
    private Class<T> configClass;
    private ScheduledExecutorService scheduledExecutorService;
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    protected abstract RevolverConfig getRevolverConfig(T var1);

    public DynamicConfigHandler(Class<T> configClass, RevolverConfig revolverConfig) {
        this.configClass = configClass;
        this.revolverConfig = revolverConfig;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
    }

    public void start() {
        this.scheduledExecutorService.scheduleWithFixedDelay(this::refreshConfig, 120L, this.revolverConfig.getConfigPollIntervalSeconds(), TimeUnit.SECONDS);
    }

    private void refreshConfig() {
        try {
            log.info("Fetching configuration from dynamic url: {}", (Object)this.revolverConfig.getDynamicConfigUrl());
            Object response = objectMapper.readValue(this.revolverConfig.getDynamicConfigUrl(), this.configClass);
            RevolverBundle.loadServiceConfiguration(this.getRevolverConfig(response));
        }
        catch (Exception e) {
            log.error("Error fetching configuration: {}", (Throwable)e);
        }
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
    }
}

